/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeAdaptive
extends BiomeGenBaseGC {
    public static BiomeAdaptive biomeDefault;
    public static List<BiomeAdaptive> biomeList;
    private Biome biomeTrue;
    private final int index;

    public BiomeAdaptive(int i, Biome biomeInitial) {
        super(new Biome.BiomeProperties("Outer Space" + (i == 0 ? "" : " " + i)).func_185395_b(0.0f));
        this.index = i;
        this.biomeTrue = biomeInitial;
        this.field_76760_I = this.func_76729_a();
        if (this.index == 0) {
            biomeDefault = this;
        }
    }

    @Override
    public void registerTypes(Biome b) {
        if (this.biomeTrue instanceof BiomeGenBaseGC) {
            ((BiomeGenBaseGC)this.biomeTrue).registerTypes(this);
        } else {
            BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY});
        }
    }

    public static BiomeGenBaseGC register(int index, BiomeGenBaseGC biome) {
        if (index >= biomeList.size()) {
            BiomeAdaptive newAdaptive = new BiomeAdaptive(index, biome);
            biomeList.add(newAdaptive);
            return newAdaptive;
        }
        return biomeList.get(index);
    }

    public static BiomeGenBaseGC getDefaultBiomeFor(CelestialBody body) {
        return body.biomesToAdapt[0];
    }

    public static void setBody(CelestialBody body) {
        biomeDefault.setBodyInstance(body);
    }

    public boolean isInstance(Class<?> clazz) {
        return clazz.isInstance(this.biomeTrue);
    }

    public static void setBodyMultiBiome(CelestialBody body) {
        for (BiomeAdaptive b : biomeList) {
            if (b.setBodyInstance(body)) break;
        }
    }

    protected boolean setBodyInstance(CelestialBody body) {
        this.biomeTrue = body.biomesToAdapt[this.index];
        this.field_76753_B = this.biomeTrue.field_76753_B;
        this.field_76752_A = this.biomeTrue.field_76752_A;
        this.field_76760_I = this.biomeTrue.field_76760_I;
        return this.index == body.biomesToAdapt.length - 1;
    }

    public static List<Biome> getBiomesListFor(CelestialBody body) {
        LinkedList<Biome> result = new LinkedList<Biome>();
        for (BiomeAdaptive b : biomeList) {
            if (result.size() >= body.biomesToAdapt.length) break;
            result.add(b);
        }
        return result;
    }

    public BiomeDecorator func_76729_a() {
        return this.biomeTrue == null ? null : this.biomeTrue.func_76729_a();
    }

    public boolean func_185363_b() {
        return this.biomeTrue.func_185363_b();
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.biomeTrue.func_150567_a(rand);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return this.biomeTrue.func_76730_b(rand);
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return this.biomeTrue.func_180623_a(rand, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return this.biomeTrue.func_76731_a(currentTemperature);
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType creatureType) {
        return this.biomeTrue.func_76747_a(creatureType);
    }

    public boolean func_76746_c() {
        return this.biomeTrue.func_76746_c();
    }

    public boolean func_76738_d() {
        return this.biomeTrue.func_76738_d();
    }

    public boolean func_76736_e() {
        return this.biomeTrue.func_76736_e();
    }

    public float func_76741_f() {
        return this.biomeTrue.func_76741_f();
    }

    public float func_180626_a(BlockPos pos) {
        return this.biomeTrue.func_180626_a(pos);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
            this.setBodyInstance(((IGalacticraftWorldProvider)worldIn.field_73011_w).getCelestialBody());
        } else {
            Thread.dumpStack();
        }
        this.biomeTrue.func_180624_a(worldIn, rand, pos);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
            this.setBodyInstance(((IGalacticraftWorldProvider)worldIn.field_73011_w).getCelestialBody());
        } else {
            Thread.dumpStack();
        }
        this.biomeTrue.func_180622_a(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return this.biomeTrue.func_180627_b(pos);
    }

    public final void func_180628_b(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
            this.setBodyInstance(((IGalacticraftWorldProvider)worldIn.field_73011_w).getCelestialBody());
        } else {
            Thread.dumpStack();
        }
        this.biomeTrue.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return this.biomeTrue.func_180625_c(pos);
    }

    public Class<? extends Biome> func_150562_l() {
        return this.biomeTrue.func_150562_l();
    }

    public Biome.TempCategory func_150561_m() {
        return this.biomeTrue.func_150561_m();
    }

    public boolean func_185352_i() {
        return this.biomeTrue.func_185352_i();
    }

    public float func_185355_j() {
        return this.biomeTrue == null ? 0.0f : this.biomeTrue.func_185355_j();
    }

    public float func_76727_i() {
        return this.biomeTrue.func_76727_i();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_185359_l() {
        return this.biomeTrue.func_185359_l();
    }

    public float func_185360_m() {
        return this.biomeTrue.func_185360_m();
    }

    public float func_185353_n() {
        return this.biomeTrue.func_185353_n();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185361_o() {
        return this.biomeTrue.func_185361_o();
    }

    public boolean func_150559_j() {
        return this.biomeTrue.func_150559_j();
    }

    public BiomeDecorator getModdedBiomeDecorator(BiomeDecorator original) {
        return this.biomeTrue.getModdedBiomeDecorator(original);
    }

    public int getWaterColorMultiplier() {
        return this.biomeTrue.getWaterColorMultiplier();
    }

    public int getModdedBiomeGrassColor(int original) {
        return this.biomeTrue.getModdedBiomeGrassColor(original);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return this.biomeTrue.getModdedBiomeFoliageColor(original);
    }

    public void addDefaultFlowers() {
        if (this.biomeTrue != null) {
            this.biomeTrue.addDefaultFlowers();
        }
    }

    public void addFlower(IBlockState state, int weight) {
        this.biomeTrue.addFlower(state, weight);
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            this.setBodyInstance(((IGalacticraftWorldProvider)world.field_73011_w).getCelestialBody());
        } else {
            Thread.dumpStack();
        }
        this.biomeTrue.plantFlower(world, rand, pos);
    }

    static {
        biomeList = new LinkedList<BiomeAdaptive>();
    }
}

