/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.proxy;

import c4.conarm.ConstructsArmory;
import c4.conarm.client.events.ClientArmorEvents;
import c4.conarm.client.fx.ParticleSoul;
import c4.conarm.client.gui.PreviewPlayer;
import c4.conarm.client.layers.LayerAccessories;
import c4.conarm.client.utils.ArmorModelLoader;
import c4.conarm.client.utils.ArmorModelUtils;
import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.armor.modifiers.ArmorModifiers;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.ArmoryRegistryClient;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.armor.ArmorPart;
import c4.conarm.lib.book.ArmoryBook;
import c4.conarm.lib.utils.ConstructUtils;
import c4.conarm.proxy.CommonProxy;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.ToolClientEvents;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final ArmorModelLoader loader = new ArmorModelLoader();
    private static final String LOCATION_ArmorForge = "conarm:armorforge";
    private static final String LOCATION_ArmorStation = "conarm:armorstation";
    private static final ModelResourceLocation locArmorForge = new ModelResourceLocation("conarm:armorforge", "normal");
    private static final ModelResourceLocation locArmorStation = new ModelResourceLocation("conarm:armorstation", "normal");
    private static final Random random = new Random();
    public static final Map<String, String> modifierCache = Maps.newHashMap();

    @Override
    public void preInit(FMLPreInitializationEvent evt) {
        super.preInit(evt);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        ArmoryBook.init();
        ClientArmorEvents.init();
    }

    @Override
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        ArmoryRegistryClient.registerArmorBuildInfo();
        MinecraftForge.EVENT_BUS.register((Object)new ClientArmorEvents());
    }

    @Override
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        manager.field_78729_o.put(PreviewPlayer.class, new RenderPlayer(manager));
        Map renderPlayerMap = manager.getSkinMap();
        for (RenderPlayer render : renderPlayerMap.values()) {
            render.func_177094_a(new LayerAccessories((RenderLivingBase<?>)render));
        }
        ArmoryBook.INSTANCE.fontRenderer = TinkerBook.INSTANCE.fontRenderer;
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ConstructsRegistry.armorForge), (int)0, (ModelResourceLocation)locArmorForge);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ConstructsRegistry.armorStation), (int)0, (ModelResourceLocation)locArmorStation);
        for (ArmorPart armorPart : ArmoryRegistry.armorParts) {
            ModelRegisterUtil.registerPartModel((Item)armorPart);
        }
        for (ArmorCore armor : ArmoryRegistry.armor) {
            ArmorModelUtils.registerArmorModel(armor);
        }
        for (IModifier modifier : ArmoryRegistry.getAllArmorModifiers()) {
            if (modifier == TinkerModifiers.modCreative || modifier == ArmorModifiers.modExtraTrait) continue;
            ModelRegisterUtil.registerModifierModel((IModifier)modifier, (ResourceLocation)ConstructUtils.getResource("models/item/modifiers/" + modifier.getIdentifier()));
        }
        ConstructsRegistry.initModels();
    }

    @SubscribeEvent
    public static void textureStitch(TextureStitchEvent.Pre evt) {
        CustomTextureCreator.registerTexture((ResourceLocation)ConstructUtils.getResource("models/armor/armor_core"));
        CustomTextureCreator.registerTexture((ResourceLocation)ConstructUtils.getResource("models/armor/armor_plates"));
        CustomTextureCreator.registerTexture((ResourceLocation)ConstructUtils.getResource("models/armor/armor_trim"));
        try {
            Map textureEntries = ModelHelper.loadTexturesFromJson((ResourceLocation)ConstructUtils.getResource("models/model_modifiers"));
            for (String s : textureEntries.keySet()) {
                IModifier mod = TinkerRegistry.getModifier((String)s);
                if (mod != null && mod.hasTexturePerMaterial()) {
                    CustomTextureCreator.registerTexture((ResourceLocation)ConstructUtils.getResource((String)textureEntries.get(s)));
                    continue;
                }
                Minecraft.func_71410_x().func_147117_R().func_174942_a(ConstructUtils.getResource((String)textureEntries.get(s)));
            }
            modifierCache.putAll(textureEntries);
        }
        catch (IOException e) {
            ConstructsArmory.logger.error("Could not load model modifiers {}", (Object)"models/model_modifiers");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void modelBake(ModelBakeEvent evt) {
        ToolClientEvents.replaceTableModel((ModelResourceLocation)locArmorForge, (ModelBakeEvent)evt);
        ToolClientEvents.replaceTableModel((ModelResourceLocation)locArmorStation, (ModelBakeEvent)evt);
    }

    @Override
    public void generateParticle(Entity entity) {
        if (entity instanceof EntityLivingBase && random.nextInt(5) == 0) {
            ParticleSoul soul = new ParticleSoul(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O / 1.25, entity.field_70161_v, (float)Math.sqrt(((EntityLivingBase)entity).func_110143_aJ()));
            soul.func_82338_g(0.35f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)soul);
        }
    }
}

