/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.tinkering;

import c4.conarm.client.models.ModelBrokenArmor;
import c4.conarm.client.models.ModelConstructsArmor;
import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.armor.ArmorModifications;
import c4.conarm.lib.client.DynamicTextureHelper;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.modifiers.IArmorModifyable;
import c4.conarm.lib.tinkering.ArmorBuilder;
import c4.conarm.lib.tinkering.ArmorTooltipBuilder;
import c4.conarm.lib.traits.IArmorTrait;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;

public abstract class TinkersArmor
extends ItemArmor
implements ITinkerable,
IArmorModifyable,
IRepairable,
ISpecialArmor {
    protected final PartMaterialType[] requiredComponents;
    protected ModelBiped model;
    protected ModelBiped brokenModel;
    private static final ItemArmor.ArmorMaterial emptyMaterial = EnumHelper.addArmorMaterial((String)"armory", (String)"empty", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);

    public TinkersArmor(EntityEquipmentSlot slotIn, PartMaterialType ... requiredComponents) {
        super(emptyMaterial, 0, slotIn);
        this.requiredComponents = requiredComponents;
        this.func_77625_d(1);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!ToolHelper.isBroken((ItemStack)itemStack)) {
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)itemStack);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (trait == null) continue;
                trait.onArmorTick(itemStack, world, player);
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (!ToolHelper.isBroken((ItemStack)armor) && !source.func_76363_c() && entity instanceof EntityPlayer) {
            EntityEquipmentSlot equipslot = EntityLiving.func_184640_d((ItemStack)armor);
            EntityPlayer player = (EntityPlayer)entity;
            ArmorModifications mods = new ArmorModifications(ArmorHelper.getArmor(armor, equipslot.func_188454_b()), ArmorHelper.getToughness(armor));
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)armor);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (trait == null || !(trait instanceof IArmorTrait)) continue;
                IArmorTrait armorTrait = (IArmorTrait)trait;
                mods = armorTrait.getModifications(player, mods, armor, source, damage, slot);
            }
            float totalToughness = mods.toughness * mods.toughnessMod * mods.effective;
            float totalArmor = mods.armor * mods.armorMod * mods.effective;
            ISpecialArmor.ArmorProperties prop = ArmorHelper.getPropertiesAfterAbsorb(armor, damage, totalArmor, totalToughness, this.field_77881_a);
            prop.Armor -= (double)ArmorHelper.getArmor(armor, equipslot.func_188454_b());
            prop.Toughness -= (double)ArmorHelper.getToughness(armor);
            return prop;
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (damage > 0 && entity instanceof EntityPlayer) {
            ArmorHelper.damageArmor(stack, source, Math.max(1, damage / 4), (EntityPlayer)entity, slot);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        ResourceLocation resourceLocation = DynamicTextureHelper.getCachedTexture(stack);
        if (resourceLocation != null) {
            return resourceLocation.toString();
        }
        return null;
    }

    public abstract String getAppearanceName();

    @SideOnly(value=Side.CLIENT)
    public String getArmorModelTexture(String type) {
        return String.format("%s_%s", "conarm:models/armor/armor", type);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.model == null) {
            this.model = new ModelConstructsArmor(armorSlot);
        }
        if (this.brokenModel == null) {
            this.brokenModel = new ModelBrokenArmor();
        }
        if (ToolHelper.isBroken((ItemStack)itemStack)) {
            return this.brokenModel;
        }
        return this.model;
    }

    public List<PartMaterialType> getRequiredComponents() {
        return ImmutableList.copyOf((Object[])this.requiredComponents);
    }

    public List<PartMaterialType> getArmorBuildComponents() {
        return this.getRequiredComponents();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.func_77958_k()) {
            stack.func_77964_b(stack.func_77958_k());
            return;
        }
        super.setDamage(stack, damage);
    }

    @Nonnull
    public Entity createEntity(World world, Entity entityIn, ItemStack itemstack) {
        IndestructibleEntityItem entity = new IndestructibleEntityItem(world, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, itemstack);
        if (entityIn instanceof EntityItem) {
            NBTTagCompound tag = new NBTTagCompound();
            entityIn.func_189511_e(tag);
            entity.func_174867_a((int)tag.func_74765_d("PickupDelay"));
        }
        entity.field_70159_w = entityIn.field_70159_w;
        entity.field_70181_x = entityIn.field_70181_x;
        entity.field_70179_y = entityIn.field_70179_y;
        return entity;
    }

    public boolean validComponent(int slot, ItemStack stack) {
        return slot <= this.requiredComponents.length && slot >= 0 && this.requiredComponents[slot].isValid(stack);
    }

    @Nonnull
    public ItemStack buildItemFromStacks(NonNullList<ItemStack> stacks) {
        long itemCount = stacks.stream().filter(stack -> !stack.func_190926_b()).count();
        ArrayList<Material> materials = new ArrayList<Material>(stacks.size());
        if (itemCount != (long)this.requiredComponents.length) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        while ((long)i < itemCount) {
            if (!this.validComponent(i, (ItemStack)stacks.get(i))) {
                return ItemStack.field_190927_a;
            }
            materials.add(TinkerUtil.getMaterialFromStack((ItemStack)((ItemStack)stacks.get(i))));
            ++i;
        }
        return this.buildItem(materials);
    }

    @Nonnull
    public ItemStack buildItem(List<Material> materials) {
        ItemStack armor = new ItemStack((Item)this);
        armor.func_77982_d(this.buildItemNBT(materials));
        return armor;
    }

    public NBTTagCompound buildItemNBT(List<Material> materials) {
        NBTTagCompound basetag = new NBTTagCompound();
        NBTTagCompound armorTag = this.buildTag(materials);
        NBTTagCompound dataTag = this.buildData(materials);
        basetag.func_74782_a("TinkerData", (NBTBase)dataTag);
        basetag.func_74782_a("Stats", (NBTBase)armorTag);
        basetag.func_74782_a("StatsOriginal", (NBTBase)armorTag.func_74737_b());
        this.addMaterialTraits(basetag, materials);
        ArmoryEvent.OnItemBuilding.fireEvent(basetag, (ImmutableList<Material>)ImmutableList.copyOf(materials), this);
        return basetag;
    }

    private NBTTagCompound buildData(List<Material> materials) {
        NBTTagCompound base = new NBTTagCompound();
        NBTTagList materialList = new NBTTagList();
        for (Material material : materials) {
            materialList.func_74742_a((NBTBase)new NBTTagString(material.identifier));
        }
        NBTTagList modifierList = new NBTTagList();
        modifierList.func_74742_a((NBTBase)new NBTTagString());
        modifierList.func_74744_a(0);
        base.func_74782_a("Materials", (NBTBase)materialList);
        base.func_74782_a("Modifiers", (NBTBase)modifierList);
        return base;
    }

    @Nonnull
    public ItemStack buildItemForRendering(List<Material> materials) {
        ItemStack armor = new ItemStack((Item)this);
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("TinkerData", (NBTBase)this.buildData(materials));
        armor.func_77982_d(base);
        return armor;
    }

    @Nonnull
    public ItemStack buildItemForRenderingInGui() {
        List<Material> materials = IntStream.range(0, this.getRequiredComponents().size()).mapToObj(this::getMaterialForPartForGuiRendering).collect(Collectors.toList());
        return this.buildItemForRendering(materials);
    }

    @SideOnly(value=Side.CLIENT)
    public Material getMaterialForPartForGuiRendering(int index) {
        return ClientProxy.RenderMaterials[index % ClientProxy.RenderMaterials.length];
    }

    public abstract NBTTagCompound buildTag(List<Material> var1);

    public boolean hasValidMaterials(ItemStack stack) {
        NBTTagList list = TagUtil.getBaseMaterialsTagList((ItemStack)stack);
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)list);
        if (materials.size() != this.requiredComponents.length) {
            return false;
        }
        for (int i = 0; i < materials.size(); ++i) {
            PartMaterialType required = this.requiredComponents[i];
            Material material = (Material)materials.get(i);
            if (required.isValidMaterial(material)) continue;
            return false;
        }
        return true;
    }

    public void addMaterialTraits(NBTTagCompound root, List<Material> materials) {
        int size = this.requiredComponents.length;
        if (materials.size() < size) {
            size = materials.size();
        }
        for (int i = 0; i < size; ++i) {
            PartMaterialType required = this.requiredComponents[i];
            Material material = materials.get(i);
            for (ITrait trait : required.getApplicableTraitsForMaterial(material)) {
                ToolBuilder.addTrait((NBTTagCompound)root, (ITrait)trait, (int)material.materialTextColor);
            }
        }
    }

    public int[] getRepairParts() {
        return new int[]{0};
    }

    public float getRepairModifierForPart(int index) {
        return 1.0f;
    }

    @Nonnull
    public ItemStack repair(ItemStack repairable, NonNullList<ItemStack> repairItems) {
        int amount;
        if (repairable.func_77952_i() == 0 && !ToolHelper.isBroken((ItemStack)repairable)) {
            return ItemStack.field_190927_a;
        }
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)repairable));
        if (materials.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        NonNullList items = Util.deepCopyFixedNonNullList(repairItems);
        boolean foundMatch = false;
        for (int index : this.getRepairParts()) {
            Optional match;
            Material material = (Material)materials.get(index);
            if (this.repairCustom(material, (NonNullList<ItemStack>)items) > 0) {
                foundMatch = true;
            }
            if (!(match = material.matches(items)).isPresent()) continue;
            foundMatch = true;
            while ((match = material.matches(items)).isPresent()) {
                RecipeMatch.removeMatch((NonNullList)items, (RecipeMatch.Match)((RecipeMatch.Match)match.get()));
            }
        }
        if (!foundMatch) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < repairItems.size(); ++i) {
            if (((ItemStack)repairItems.get(i)).func_190926_b() || !ItemStack.func_77989_b((ItemStack)((ItemStack)repairItems.get(i)), (ItemStack)((ItemStack)items.get(i)))) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack item = repairable.func_77946_l();
        while (item.func_77952_i() > 0 && (amount = this.calculateRepairAmount(materials, repairItems, EntityLiving.func_184640_d((ItemStack)repairable))) > 0) {
            ArmorHelper.repairArmor(item, this.calculateRepair(item, amount));
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)item);
            tag.func_74768_a("RepairCount", tag.func_74762_e("RepairCount") + 1);
            TagUtil.setExtraTag((ItemStack)item, (NBTTagCompound)tag);
        }
        return item;
    }

    protected int repairCustom(Material material, NonNullList<ItemStack> repairItems) {
        return 0;
    }

    protected int calculateRepairAmount(List<Material> materials, NonNullList<ItemStack> repairItems, EntityEquipmentSlot slotIn) {
        HashSet materialsMatched = Sets.newHashSet();
        float durability = 0.0f;
        for (int index : this.getRepairParts()) {
            Material material = materials.get(index);
            if (materialsMatched.contains(material)) continue;
            durability += (float)(this.repairCustom(material, repairItems) * ArmorHelper.durabilityMultipliers[slotIn.func_188454_b()]) * this.getRepairModifierForPart(index);
            Optional matchOptional = material.matches(repairItems);
            if (!matchOptional.isPresent()) continue;
            RecipeMatch.Match match = (RecipeMatch.Match)matchOptional.get();
            CoreMaterialStats stats = (CoreMaterialStats)material.getStats(ArmorMaterialType.CORE);
            if (stats == null) continue;
            materialsMatched.add(material);
            durability += stats.durability * (float)ArmorHelper.durabilityMultipliers[slotIn.func_188454_b()] * (float)match.amount * this.getRepairModifierForPart(index) / 144.0f;
            RecipeMatch.removeMatch(repairItems, (RecipeMatch.Match)match);
        }
        return (int)(durability *= 1.0f + ((float)materialsMatched.size() - 1.0f) / 9.0f);
    }

    protected int calculateRepair(ItemStack tool, int amount) {
        float origDur = TagUtil.getOriginalToolStats((ItemStack)tool).durability;
        float actualDur = ToolHelper.getDurabilityStat((ItemStack)tool);
        float durabilityFactor = actualDur / origDur;
        float increase = (float)amount * Math.min(10.0f, durabilityFactor);
        increase = Math.max(increase, actualDur / 64.0f);
        int modifiersUsed = TagUtil.getBaseModifiersUsed((NBTTagCompound)tool.func_77978_p());
        float mods = 1.0f;
        if (modifiersUsed == 1) {
            mods = 0.95f;
        } else if (modifiersUsed == 2) {
            mods = 0.9f;
        } else if (modifiersUsed >= 3) {
            mods = 0.85f;
        }
        increase *= mods;
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        int repair = tag.func_74762_e("RepairCount");
        float repairDimishingReturns = (float)(100 - repair / 2) / 100.0f;
        if (repairDimishingReturns < 0.5f) {
            repairDimishingReturns = 0.5f;
        }
        return (int)Math.ceil(increase *= repairDimishingReturns);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            this.getTooltip(stack, tooltip);
            tooltip.add("");
            tooltip.add(Util.translate((String)"tooltip.tool.holdShift", (Object[])new Object[0]));
            tooltip.add(Util.translate((String)"tooltip.tool.holdCtrl", (Object[])new Object[0]));
        } else if (Config.extraTooltips && shift) {
            this.getTooltipDetailed(stack, tooltip);
        } else if (Config.extraTooltips && ctrl) {
            this.getTooltipComponents(stack, tooltip);
        }
    }

    public void getTooltip(ItemStack stack, List<String> tooltips) {
        ArmorTooltipBuilder.addModifierTooltips(stack, tooltips);
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TinkerData")) {
            try {
                ArmorBuilder.rebuildArmor(nbt, this);
            }
            catch (TinkerGuiException tinkerGuiException) {
                // empty catch block
            }
        }
        return true;
    }
}

