/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.contenttweaker.traits;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.traits.ITrait;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.contenttweaker.conarm.ArmorTrait")
@ZenRegister
@ModOnly(value="contenttweaker")
public class ConArmTraitRepresentation {
    private final ITrait trait;

    public ConArmTraitRepresentation(ITrait trait) {
        this.trait = trait;
    }

    public static ConArmTraitRepresentation getFromString(String identifier) {
        ITrait trait = TinkerRegistry.getTrait((String)identifier);
        if (trait == null) {
            CraftTweakerAPI.logError((String)("Cannot identify trait <conarmtrait:" + identifier + ">"));
            return null;
        }
        return new ConArmTraitRepresentation(trait);
    }

    @ZenMethod
    public void addItem(IIngredient item, @Optional(valueLong=1L) int amountNeeded, @Optional(valueLong=1L) int amountMatched) {
        if (!(this.trait instanceof RecipeMatchRegistry)) {
            CraftTweakerAPI.logError((String)("Cannot add item " + item.toCommandString() + " to trait " + this.toCommandString()));
            return;
        }
        RecipeMatchRegistry trait = (RecipeMatchRegistry)this.trait;
        if (item instanceof IItemStack) {
            trait.addItem(CraftTweakerMC.getItemStack((IIngredient)item), amountNeeded, amountMatched);
        } else if (item instanceof IOreDictEntry) {
            trait.addItem(((IOreDictEntry)item).getName(), amountNeeded, amountMatched);
        } else {
            for (IItemStack itemStack : item.getItems()) {
                this.addItem((IIngredient)itemStack, amountNeeded, amountMatched);
            }
        }
    }

    @ZenGetter(value="identifier")
    public String getIdentifier() {
        return this.trait.getIdentifier();
    }

    @ZenGetter(value="commandString")
    public String toCommandString() {
        return "<conarmtrait:" + this.trait.getIdentifier() + ">";
    }

    public ITrait getTrait() {
        return this.trait;
    }
}

