/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.events;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.capabilities.ArmorAbilityHandler;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.traits.IArmorAbility;
import c4.conarm.lib.traits.IArmorTrait;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ArmorEvents {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        ArmorAbilityHandler.IArmorAbilities armorAbilities;
        if (evt.phase == TickEvent.Phase.END && (armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(evt.player)) != null) {
            for (String identifier : armorAbilities.getAbilityMap().keySet()) {
                ITrait trait = TinkerRegistry.getTrait((String)identifier);
                if (trait == null || !(trait instanceof IArmorTrait)) continue;
                ((IArmorTrait)trait).onAbilityTick(armorAbilities.getAbilityLevel(identifier), evt.player.field_70170_p, evt.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        ArmorAbilityHandler.IArmorAbilities armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(evt.player);
        if (armorAbilities != null) {
            armorAbilities.clearAllAbilities();
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent evt) {
        ItemStack from;
        if (!(evt.getEntityLiving() instanceof EntityPlayer) || evt.getSlot() == EntityEquipmentSlot.OFFHAND || evt.getSlot() == EntityEquipmentSlot.MAINHAND) {
            return;
        }
        EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
        ArmorAbilityHandler.IArmorAbilities armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(player);
        if (armorAbilities == null) {
            return;
        }
        armorAbilities.clearAllAbilities();
        if (evt.getFrom().func_77973_b() instanceof TinkersArmor && !ToolHelper.isBroken((ItemStack)(from = evt.getFrom()))) {
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)from);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (trait == null || !(trait instanceof IArmorTrait)) continue;
                ((IArmorTrait)trait).onArmorChanged(from, player, evt.getSlot().func_188454_b());
            }
        }
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
            NBTTagList list = TagUtil.getModifiersTagList((ItemStack)stack);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                IModifier mod = TinkerRegistry.getModifier((String)compound.func_74779_i("identifier"));
                if (mod == null || !(mod instanceof IArmorAbility)) continue;
                ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)compound);
                ArmorHelper.addArmorAbility(player, mod.getIdentifier(), ((IArmorAbility)mod).getAbilityLevel(data));
            }
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    ((IArmorTrait)trait).onJumping(stack, player, evt);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerPickUp(EntityItemPickupEvent evt) {
        EntityItem entityItem = evt.getItem();
        EntityPlayer player = evt.getEntityPlayer();
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
            NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                if (trait == null || !(trait instanceof IArmorTrait)) continue;
                ((IArmorTrait)trait).onItemPickup(stack, entityItem, evt);
            }
        }
    }

    @SubscribeEvent
    public void playerHeal(LivingHealEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer) {
            float amount;
            float newAmount = amount = evt.getAmount();
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    newAmount = ((IArmorTrait)trait).onHeal(stack, player, amount, newAmount, evt);
                }
            }
            evt.setAmount(Math.max(0.0f, newAmount));
        }
    }

    @SubscribeEvent
    public void playerHurt(LivingHurtEvent evt) {
        if (evt.getSource() instanceof EntityDamageSource && ((EntityDamageSource)evt.getSource()).func_180139_w()) {
            return;
        }
        if (evt.getEntity() instanceof EntityPlayer) {
            float damage;
            float newDamage = damage = evt.getAmount();
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    newDamage = ((IArmorTrait)trait).onHurt(stack, player, evt.getSource(), damage, newDamage, evt);
                }
            }
            evt.setAmount(Math.max(0.0f, newDamage));
        }
    }

    @SubscribeEvent
    public void playerKnockback(LivingKnockBackEvent evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    ((IArmorTrait)trait).onKnockback(stack, player, evt);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerFall(LivingFallEvent evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    ((IArmorTrait)trait).onFalling(stack, player, evt);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerDamaged(LivingDamageEvent evt) {
        if (evt.getSource() instanceof EntityDamageSource && ((EntityDamageSource)evt.getSource()).func_180139_w()) {
            return;
        }
        if (evt.getEntity() instanceof EntityPlayer) {
            float damage;
            float newDamage = damage = evt.getAmount();
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            for (ItemStack stack : player.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)stack)) continue;
                NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
                    if (trait == null || !(trait instanceof IArmorTrait)) continue;
                    newDamage = ((IArmorTrait)trait).onDamaged(stack, player, evt.getSource(), damage, newDamage, evt);
                }
            }
            evt.setAmount(Math.max(newDamage, damage * 0.2f));
        }
    }

    @SubscribeEvent
    public void onRepair(ArmoryEvent.OnRepair event) {
        ItemStack armor = event.itemStack;
        NBTTagList list = TagUtil.getTraitsTagList((ItemStack)armor);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
            if (trait == null) continue;
            trait.onRepair(armor, event.amount);
        }
    }
}

