/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.utils;

import c4.conarm.lib.capabilities.ArmorAbilityHandler;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.traits.IArmorAbility;
import c4.conarm.lib.traits.IArmorTrait;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ArmorHelper {
    public static final int[] durabilityMultipliers = new int[]{13, 15, 16, 11};
    public static final float[] defenseMultipliers = new float[]{0.14f, 0.3f, 0.4f, 0.16f};
    protected static final float[] ARMOR_PROTECTION_CAPS = new float[]{0.12f, 0.24f, 0.32f, 0.12f};

    public static boolean isUnbrokenTinkersArmor(ItemStack stack) {
        return stack.func_77973_b() instanceof TinkersArmor && !ToolHelper.isBroken((ItemStack)stack);
    }

    public static ISpecialArmor.ArmorProperties getPropertiesAfterAbsorb(ItemStack armor, double damage, float totalArmor, float totalToughness, EntityEquipmentSlot slot) {
        float defenseReduction = (float)damage / (totalToughness / 4.0f + 2.0f) * 0.01f;
        float absorbRatio = MathHelper.func_76131_a((float)(totalArmor / 25.0f - defenseReduction), (float)(totalArmor / 125.0f), (float)ARMOR_PROTECTION_CAPS[slot.func_188454_b()]);
        return new ISpecialArmor.ArmorProperties(0, (double)absorbRatio, (int)Math.ceil(Math.max(damage, (double)((armor.func_77958_k() - armor.func_77952_i()) * 4))));
    }

    public static float getArmor(ItemStack stack, int slot) {
        if (slot > 3) {
            return 0.0f;
        }
        return (float)((int)((double)(ArmorHelper.getDefense(stack) * defenseMultipliers[slot] * 100.0f) + 0.5)) / 100.0f;
    }

    public static float getDefense(ItemStack stack) {
        return ArmorHelper.getFloatTag(stack, "Defense");
    }

    public static float getToughness(ItemStack stack) {
        return ArmorHelper.getFloatTag(stack, "Toughness");
    }

    private static float getFloatTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag((ItemStack)stack);
        return tag.func_74760_g(key);
    }

    public static double getArmorAbilityLevel(EntityPlayer entityplayer, String identifier) {
        ArmorAbilityHandler.IArmorAbilities armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(entityplayer);
        if (armorAbilities != null) {
            return armorAbilities.getAbilityLevel(identifier);
        }
        return 0.0;
    }

    public static void addArmorAbility(EntityPlayer entityplayer, String identifier, int amount) {
        ArmorAbilityHandler.IArmorAbilities armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(entityplayer);
        if (armorAbilities != null) {
            armorAbilities.addAbility(identifier, amount);
        }
    }

    public static void removeArmorAbility(EntityPlayer entityplayer, String identifier, int amount) {
        ArmorAbilityHandler.IArmorAbilities armorAbilities = ArmorAbilityHandler.getArmorAbilitiesData(entityplayer);
        if (armorAbilities != null) {
            armorAbilities.removeAbility(identifier, amount);
        }
    }

    public static void damageArmor(ItemStack stack, DamageSource source, int amount, EntityPlayer player, int slot) {
        int i;
        if (amount == 0 || ToolHelper.isBroken((ItemStack)stack)) {
            return;
        }
        int actualAmount = amount;
        NBTTagList list = TagUtil.getTraitsTagList((ItemStack)stack);
        for (i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait((String)list.func_150307_f(i));
            if (trait == null || !(trait instanceof IArmorTrait)) continue;
            actualAmount = amount > 0 ? ((IArmorTrait)trait).onArmorDamage(stack, source, amount, actualAmount, player, slot) : ((IArmorTrait)trait).onArmorHeal(stack, source, amount, actualAmount, player, slot);
        }
        if (actualAmount > 0 && TagUtil.getTagSafe((ItemStack)stack).func_74767_n("Unbreakable")) {
            actualAmount = 0;
        }
        actualAmount = Math.min(actualAmount, ToolHelper.getCurrentDurability((ItemStack)stack));
        stack.func_77964_b(stack.func_77952_i() + actualAmount);
        if (ToolHelper.getCurrentDurability((ItemStack)stack) == 0) {
            ToolHelper.breakTool((ItemStack)stack, (EntityLivingBase)player);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                IModifier mod = TinkerRegistry.getModifier((String)compound.func_74779_i("identifier"));
                if (mod == null || !(mod instanceof IArmorAbility)) continue;
                ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)compound);
                ArmorHelper.removeArmorAbility(player, mod.getIdentifier(), ((IArmorAbility)mod).getAbilityLevel(data));
            }
        }
    }

    public static void healArmor(ItemStack stack, int amount, EntityPlayer player, int slot) {
        ArmorHelper.damageArmor(stack, new DamageSource("heal"), -amount, player, slot);
    }

    public static void repairArmor(ItemStack stack, int amount) {
        ArmorHelper.repairArmor(stack, amount, null);
    }

    public static void repairArmor(ItemStack stack, int amount, EntityPlayer player) {
        ToolHelper.unbreakTool((ItemStack)stack);
        ArmoryEvent.OnRepair.fireEvent(stack, amount);
        ArmorHelper.healArmor(stack, amount, player, EntityLiving.func_184640_d((ItemStack)stack).func_188454_b());
    }
}

