/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;

public class ModAmphibious
extends ArmorModifierTrait {
    private static final String TAG_OXYGEN = "oxygen";
    private static final int MAX_CAPACITY = 1200;

    public ModAmphibious() {
        super("amphibious", 52479);
        this.addAspects(new ModifierAspect[]{new ModifierAspect.SingleAspect((IModifier)this)});
    }

    public void onArmorTick(ItemStack armor, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)armor, (String)this.getModifierIdentifier());
            OxygenData data = (OxygenData)modtag.getTagData(OxygenData.class);
            if (player.func_70090_H()) {
                if (player.func_70086_ai() < 300 && data.oxygen > 0) {
                    this.addOxygen(modtag, data, -1);
                    player.func_70050_g(player.func_70086_ai() + 1);
                }
            } else if (this.canStoreOxygen(data)) {
                this.addOxygen(modtag, data, 1200);
            }
        }
    }

    private boolean canStoreOxygen(OxygenData data) {
        return data.oxygen < 1200;
    }

    private void addOxygen(ModifierTagHolder modtag, OxygenData data, int amount) {
        data.oxygen = MathHelper.func_76125_a((int)(data.oxygen + amount), (int)0, (int)1200);
        modtag.save();
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD && super.canApplyCustom(stack);
    }

    public static class OxygenData
    extends ModifierNBT {
        public int oxygen = 0;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.oxygen = tag.func_74762_e(ModAmphibious.TAG_OXYGEN);
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a(ModAmphibious.TAG_OXYGEN, this.oxygen);
        }
    }
}

