/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.armor.modifiers.ModAmphibious;
import c4.conarm.common.armor.modifiers.ModDexterous;
import c4.conarm.common.armor.modifiers.ModDiamond;
import c4.conarm.common.armor.modifiers.ModEmerald;
import c4.conarm.common.armor.modifiers.ModExtraArmorTrait;
import c4.conarm.common.armor.modifiers.ModExtraArmorTraitDisplay;
import c4.conarm.common.armor.modifiers.ModFrostWalker;
import c4.conarm.common.armor.modifiers.ModGlowing;
import c4.conarm.common.armor.modifiers.ModHighStride;
import c4.conarm.common.armor.modifiers.ModMending;
import c4.conarm.common.armor.modifiers.ModParasitic;
import c4.conarm.common.armor.modifiers.ModPolished;
import c4.conarm.common.armor.modifiers.ModPolishedDisplay;
import c4.conarm.common.armor.modifiers.ModPowerful;
import c4.conarm.common.armor.modifiers.ModReinforced;
import c4.conarm.common.armor.modifiers.ModResistantType;
import c4.conarm.common.armor.modifiers.ModShulkerweight;
import c4.conarm.common.armor.modifiers.ModSoulbound;
import c4.conarm.common.armor.modifiers.ModSpeedy;
import c4.conarm.common.armor.modifiers.ModSticky;
import c4.conarm.common.armor.modifiers.ModTelekinetic;
import c4.conarm.common.armor.modifiers.accessories.ModTravelBelt;
import c4.conarm.common.armor.modifiers.accessories.ModTravelGoggles;
import c4.conarm.common.armor.modifiers.accessories.ModTravelNight;
import c4.conarm.common.armor.modifiers.accessories.ModTravelPotion;
import c4.conarm.common.armor.modifiers.accessories.ModTravelSack;
import c4.conarm.common.armor.modifiers.accessories.ModTravelSlowFall;
import c4.conarm.common.armor.modifiers.accessories.ModTravelSneak;
import c4.conarm.common.armor.modifiers.accessories.ModTravelSoul;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.utils.RecipeMatchHolder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ModExtraTrait;

public class ArmorModifiers {
    public static Modifier modSpeedy;
    public static Modifier modParasitic;
    public static Modifier modPowerful;
    public static Modifier modTelekinetic;
    public static Modifier modDexterous;
    public static Modifier modEmerald;
    public static Modifier modDiamond;
    public static Modifier modAmphibious;
    public static Modifier modWaterwalk;
    public static Modifier modSticky;
    public static Modifier modShulkerweight;
    public static Modifier modHighStride;
    public static Modifier modGlowing;
    public static Modifier modMending;
    public static Modifier modFireResist;
    public static Modifier modProjResist;
    public static Modifier modBlastResist;
    public static Modifier modResist;
    public static Modifier modReinforced;
    public static Modifier modSoulbound;
    public static Modifier modPolished;
    public static Modifier modExtraTrait;
    public static AccessoryModifier modTravelBelt;
    public static AccessoryModifier modTravelPotion;
    public static AccessoryModifier modTravelSack;
    public static AccessoryModifier modTravelGoggles;
    public static AccessoryModifier modTravelNight;
    public static AccessoryModifier modTravelSoul;
    public static AccessoryModifier modTravelSneak;
    public static AccessoryModifier modTravelSlowFall;
    static List<Modifier> polishedMods;
    static List<Modifier> extraTraitMods;
    private static Map<String, ModExtraArmorTrait> extraTraitLookup;

    public static void setupModifiers() {
        modSpeedy = new ModSpeedy(50);
        RecipeMatchHolder.addItem((IModifier)modSpeedy, "dustRedstone");
        RecipeMatchHolder.addItem((IModifier)modSpeedy, "blockRedstone", 1, 9);
        modPowerful = new ModPowerful();
        RecipeMatchHolder.addItem((IModifier)modPowerful, ConstructsRegistry.gauntletAttack);
        modDexterous = new ModDexterous();
        RecipeMatchHolder.addItem((IModifier)modDexterous, ConstructsRegistry.gauntletSpeed);
        modTelekinetic = new ModTelekinetic();
        RecipeMatchHolder.addItem((IModifier)modTelekinetic, ConstructsRegistry.gauntletReach);
        modGlowing = new ModGlowing();
        RecipeMatchHolder.addRecipeMatch((IModifier)modGlowing, (RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151114_aO)}));
        modHighStride = new ModHighStride();
        RecipeMatchHolder.addRecipeMatch((IModifier)modHighStride, (RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Block)Blocks.field_150331_J), new ItemStack((Block)Blocks.field_150331_J)}));
        modShulkerweight = new ModShulkerweight(20);
        RecipeMatchHolder.addItem((IModifier)modShulkerweight, Items.field_185162_cT);
        modSticky = new ModSticky();
        RecipeMatchHolder.addItem((IModifier)modSticky, Blocks.field_150321_G, 1);
        modParasitic = new ModParasitic();
        RecipeMatchHolder.addItem((IModifier)modParasitic, "boneWithered");
        modDiamond = new ModDiamond();
        RecipeMatchHolder.addItem((IModifier)modDiamond, "gemDiamond");
        modEmerald = new ModEmerald();
        RecipeMatchHolder.addItem((IModifier)modEmerald, "gemEmerald");
        modSoulbound = new ModSoulbound();
        RecipeMatchHolder.addItem((IModifier)modSoulbound, Items.field_151156_bN);
        modMending = new ModMending();
        RecipeMatchHolder.addItem((IModifier)modMending, TinkerCommons.matMendingMoss, 1, 1);
        modReinforced = new ModReinforced();
        RecipeMatchHolder.addItem((IModifier)modReinforced, TinkerCommons.matReinforcement, 1, 1);
        modFireResist = new ModResistantType("fire_resistant", 15375922, EnchantmentProtection.Type.FIRE);
        RecipeMatchHolder.addItem((IModifier)modFireResist, ConstructsRegistry.fireResistMat);
        modBlastResist = new ModResistantType("blast_resistant", 8793389, EnchantmentProtection.Type.EXPLOSION);
        RecipeMatchHolder.addItem((IModifier)modBlastResist, ConstructsRegistry.blastResistMat);
        modProjResist = new ModResistantType("projectile_resistant", 1070923, EnchantmentProtection.Type.PROJECTILE);
        RecipeMatchHolder.addItem((IModifier)modProjResist, ConstructsRegistry.projResistMat);
        modResist = new ModResistantType("resistant", 0xFFF6F6, EnchantmentProtection.Type.ALL);
        RecipeMatchHolder.addItem((IModifier)modResist, ConstructsRegistry.resistMat);
        modAmphibious = new ModAmphibious();
        RecipeMatchHolder.addRecipeMatch((IModifier)modAmphibious, (RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Items.field_179563_cD), new ItemStack(Blocks.field_150359_w)}));
        modWaterwalk = new ModFrostWalker();
        RecipeMatchHolder.addRecipeMatch((IModifier)modWaterwalk, (RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150403_cj), new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150403_cj)}));
        modTravelBelt = new ModTravelBelt();
        RecipeMatchHolder.addItem((IModifier)modTravelBelt, ConstructsRegistry.travelBelt);
        modTravelPotion = new ModTravelPotion();
        RecipeMatchHolder.addItem((IModifier)modTravelPotion, ConstructsRegistry.travelPotion);
        modTravelSack = new ModTravelSack();
        RecipeMatchHolder.addItem((IModifier)modTravelSack, ConstructsRegistry.travelSack);
        modTravelGoggles = new ModTravelGoggles();
        RecipeMatchHolder.addItem((IModifier)modTravelGoggles, ConstructsRegistry.travelGoggles);
        modTravelNight = new ModTravelNight();
        RecipeMatchHolder.addItem((IModifier)modTravelNight, ConstructsRegistry.travelNight);
        modTravelSoul = new ModTravelSoul();
        RecipeMatchHolder.addItem((IModifier)modTravelSoul, ConstructsRegistry.travelSoul);
        modTravelSlowFall = new ModTravelSlowFall();
        RecipeMatchHolder.addItem((IModifier)modTravelSlowFall, ConstructsRegistry.travelSlowFall);
        modTravelSneak = new ModTravelSneak();
        RecipeMatchHolder.addItem((IModifier)modTravelSneak, ConstructsRegistry.travelSneak);
        modPolished = new ModPolishedDisplay();
        ArmoryRegistry.registerModifier((IModifier)modPolished);
        modExtraTrait = new ModExtraArmorTraitDisplay();
        ArmoryRegistry.registerModifier((IModifier)modExtraTrait);
        ArmoryRegistry.registerModifier(TinkerModifiers.modCreative.getIdentifier(), (IModifier)TinkerModifiers.modCreative);
        RecipeMatchHolder.addItem((IModifier)TinkerModifiers.modCreative, TinkerCommons.matCreativeModifier, 1, 1);
    }

    public static void registerPolishedModifiers() {
        polishedMods = Lists.newArrayList();
        for (Material mat : TinkerRegistry.getAllMaterialsWithStats((String)ArmorMaterialType.PLATES)) {
            ModPolished mod = new ModPolished(mat);
            polishedMods.add((Modifier)mod);
            ArmoryRegistry.registerModifier((IModifier)mod);
        }
    }

    public static void registerExtraTraitModifiers() {
        TinkerRegistry.getAllMaterials().forEach(ArmorModifiers::registerExtraTraitModifiers);
        extraTraitMods = Lists.newArrayList(extraTraitLookup.values());
    }

    private static void registerExtraTraitModifiers(Material material) {
        ArmoryRegistry.getArmor().forEach(armor -> ArmorModifiers.registerExtraTraitModifiers(material, armor));
    }

    private static void registerExtraTraitModifiers(Material material, ArmorCore armor) {
        armor.getRequiredComponents().forEach(pmt -> ArmorModifiers.registerExtraTraitModifiers(material, armor, pmt));
    }

    private static void registerExtraTraitModifiers(Material material, ArmorCore armor, PartMaterialType partMaterialType) {
        partMaterialType.getPossibleParts().forEach(part -> ArmorModifiers.registerExtraTraitModifiers(material, armor, partMaterialType, part));
    }

    private static <T extends Item> void registerExtraTraitModifiers(Material material, ArmorCore armor, PartMaterialType partMaterialType, IToolPart armorPart) {
        Collection traits;
        if (armorPart instanceof Item && !(traits = partMaterialType.getApplicableTraitsForMaterial(material)).isEmpty()) {
            ImmutableSet traits2 = ImmutableSet.copyOf((Collection)traits);
            String identifier = ModExtraTrait.generateIdentifier((Material)material, (Collection)traits2);
            ModExtraArmorTrait mod = extraTraitLookup.computeIfAbsent(identifier, arg_0 -> ArmorModifiers.lambda$registerExtraTraitModifiers$3(material, (Collection)traits2, identifier, arg_0));
            mod.addCombination(armor, (Item)armorPart);
        }
    }

    private static /* synthetic */ ModExtraArmorTrait lambda$registerExtraTraitModifiers$3(Material material, Collection traits2, String identifier, String id) {
        return new ModExtraArmorTrait(material, traits2, identifier);
    }

    static {
        extraTraitLookup = new HashMap<String, ModExtraArmorTrait>();
    }
}

