/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.schematic.BlockWaypoint;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.structurize.coremod.blocks.ModBlocks;
import com.structurize.coremod.placementhandlers.IPlacementHandler;
import com.structurize.coremod.placementhandlers.PlacementHandlers;
import com.structurize.structures.helpers.StructureProxy;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;

public final class StructureWrapper
extends com.structurize.coremod.util.StructureWrapper {
    public StructureWrapper(World worldObj, String name) {
        super(worldObj, new StructureProxy(worldObj, name), name);
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, boolean complete) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.position = pos;
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.placeStructure(pos.func_177973_b((Vec3i)structureWrapper.getOffset()), complete);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotateWithMirror(times, world, rotatePos, mirror);
    }

    private void placeStructure(@NotNull BlockPos pos, boolean complete) {
        BlockPos localPos;
        this.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !complete || localBlock instanceof AbstractBlockHut) continue;
                    if (localState.func_185904_a().func_76220_a()) {
                        this.handleBlockPlacement(worldPos, localState, complete, this.structure.getBlockInfo((BlockPos)localPos).field_186244_c, this.world);
                        continue;
                    }
                    delayedBlocks.add(localPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.handleBlockPlacement(newWorldPos, localState, complete, this.structure.getBlockInfo((BlockPos)coords).field_186244_c, this.world);
        }
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    Template.EntityInfo info = this.structure.getEntityinfo(localPos);
                    if (info == null) continue;
                    try {
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)info.field_186249_c, (World)this.world);
                        entity.func_184221_a(UUID.randomUUID());
                        this.world.func_72838_d(entity);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Log.getLogger().info("Couldn't restore entity", (Throwable)e);
                    }
                }
            }
        }
    }

    private void handleBlockPlacement(BlockPos pos, IBlockState localState, boolean complete, NBTTagCompound tileEntityData, World world) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            if (!handlers.canHandle(world, pos, localState)) continue;
            Object result = handlers.handle(world, pos, localState, tileEntityData, complete, this.position);
            if (result instanceof IBlockState) {
                AbstractBuilding building;
                IBlockState blockState = (IBlockState)result;
                Colony colony = ColonyManager.getColonyByPosFromWorld(world, pos);
                if (colony != null && (building = colony.getBuildingManager().getBuilding(this.position)) != null) {
                    building.registerBlockPosition(blockState, pos, world);
                }
                return;
            }
            return;
        }
    }

    public static boolean tryToLoadAndPlaceSupplyCampWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            if (structureWrapper.checkForFreeSpace(pos)) {
                structureWrapper.placeStructure(pos, false);
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return false;
        }
    }

    public boolean isStructureBlockEqualWorldBlock() {
        IBlockState structureBlockState = this.structure.getBlockState(this.getLocalPosition());
        Block structureBlock = structureBlockState.func_177230_c();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.func_180495_p(worldPos);
        if (structureBlock == ModBlocks.blockSolidSubstitution && worldBlockState.func_185904_a().func_76220_a()) {
            return true;
        }
        Block worldBlock = worldBlockState.func_177230_c();
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
            return structureBlock == worldBlock;
        }
        if (worldBlock == com.minecolonies.coremod.blocks.ModBlocks.blockRack) {
            return BlockMinecoloniesRack.shouldBlockBeReplacedWithRack(structureBlock);
        }
        if (structureBlock instanceof BlockStairs && structureBlockState == worldBlockState || BlockUtils.isGrassOrDirt(structureBlock, worldBlock, structureBlockState, worldBlockState) || structureBlock instanceof BlockWaypoint) {
            return true;
        }
        Template.EntityInfo entityInfo = this.structure.getEntityinfo(this.getLocalPosition());
        if (entityInfo != null) {
            return false;
        }
        return worldPos.func_177956_o() <= 0 || structureBlockState == worldBlockState;
    }
}

