/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.util.BackUpHelper;
import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(Chunk chunk, World world) {
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            return;
        }
        if (cap.getMissingChunksToLoad() > 0) {
            IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
            if (chunkManager == null) {
                Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
                cap.setMissingChunksToLoad(cap.getMissingChunksToLoad() - 1);
            }
        }
    }

    public static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        storage.applyToCap(cap);
        chunk.func_76630_e();
        if (cap != null) {
            MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    public static void loadChunkStorageToWorldCapability(World world) {
        File chunkDir = new File(world.func_72860_G().func_75765_b(), "minecolonies/chunkInfo");
        if (!chunkDir.exists()) {
            return;
        }
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        File[] files = chunkDir.listFiles();
        if (files != null) {
            for (File file : files) {
                NBTTagCompound chunkData = BackUpHelper.loadNBTFromPath(file);
                if (chunkData == null) continue;
                ChunkLoadStorage storage = new ChunkLoadStorage(chunkData);
                int z = (int)(storage.getXz() >> 32);
                int x = (int)storage.getXz();
                chunkManager.addChunkStorage(x, z, storage);
                file.delete();
            }
        }
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center, int dimension) {
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, id);
        int chunkX = centralChunk.field_76635_g;
        int chunkZ = centralChunk.field_76647_h;
        int range = Configurations.gameplay.workingRangeTownHallChunks;
        int buffer = Configurations.gameplay.townHallPaddingChunk;
        ChunkDataHelper.claimChunksInRange(id, dimension, add, chunkX, chunkZ, range, buffer, world);
    }

    public static void claimChunksInRange(int colonyId, int dimension, boolean add, int chunkX, int chunkZ, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!");
            return;
        }
        int maxRange = range * 2 + buffer;
        int additionalChunksToLoad = 0;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ChunkDataHelper.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), add, dimension, owning);
                if (chunkManager.addChunkStorage(i, j, newStorage)) continue;
                ++additionalChunksToLoad;
            }
        }
        IColonyManagerCapability cap = (IColonyManagerCapability)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension).getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        cap.setMissingChunksToLoad(cap.getMissingChunksToLoad() + additionalChunksToLoad);
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (((IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() == id && add) {
            return false;
        }
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap == null) {
            return false;
        }
        if (add) {
            cap.setOwningColony(id);
            cap.addColony(id);
        } else {
            cap.removeColony(id);
        }
        chunk.func_76630_e();
        MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        return true;
    }
}

