/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.sounds;

import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class KnightSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 3;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (isFemale) {
            return;
        }
        switch (rand.nextInt(4)) {
            case 1: {
                SoundEvent noises = Male.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
            case 2: {
                this.playSaturationSound(worldIn, position, isFemale, saturation);
                break;
            }
            case 3: {
                SoundEvent greeting = Male.greeting;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, greeting, this.getBasicSoundChance() * 2);
                break;
            }
            case 4: {
                SoundEvent farewell = Male.farewell;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, farewell, this.getBasicSoundChance());
                break;
            }
            default: {
                SoundEvent generalPhrases = Male.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "knight";
    }

    @Override
    public void playInteractionSound(World worldIn, BlockPos position, boolean isFemale) {
        if (isFemale) {
            return;
        }
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Male.interaction, this.getBasicSoundChance());
    }

    public void playSaturationSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (isFemale) {
            return;
        }
        SoundEvent saturationFeedback = saturation < 3.0 ? Male.saturationVeryLow : (saturation < 5.0 ? Male.saturationLow : Male.saturationHigh);
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, saturationFeedback, this.getBasicSoundChance());
    }

    public static final class Male {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.guard.knight.male.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.guard.knight.male.noise");
        public static final SoundEvent retrieve = ModSoundEvents.getSoundID("mob.guard.knight.male.retrieve");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.guard.knight.male.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.guard.knight.male.badWeather");
        public static final SoundEvent saturationVeryLow = ModSoundEvents.getSoundID("mob.guard.knight.male.saturationVeryLow");
        public static final SoundEvent saturationLow = ModSoundEvents.getSoundID("mob.guard.knight.male.saturationLow");
        public static final SoundEvent saturationHigh = ModSoundEvents.getSoundID("mob.guard.knight.male.saturationHigh");
        public static final SoundEvent levelUp = ModSoundEvents.getSoundID("mob.guard.knight.male.levelup");
        public static final SoundEvent badHousing = ModSoundEvents.getSoundID("mob.guard.knight.male.badhousing");
        public static final SoundEvent greeting = ModSoundEvents.getSoundID("mob.guard.knight.male.greeting");
        public static final SoundEvent farewell = ModSoundEvents.getSoundID("mob.guard.knight.male.farewell");
        public static final SoundEvent interaction = ModSoundEvents.getSoundID("mob.guard.knight.male.interaction");

        private Male() {
        }
    }

    public static final class Female {
        private Female() {
        }
    }
}

