/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.schematic.BlockWaypoint;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.structurize.coremod.blocks.schematic.BlockSolidSubstitution;
import com.structurize.coremod.placementhandlers.IPlacementHandler;
import com.structurize.coremod.placementhandlers.PlacementHandlers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecoloniesPlacementHandlers {
    private MinecoloniesPlacementHandlers() {
    }

    public static void initHandlers() {
        PlacementHandlers.handlers.clear();
        PlacementHandlers.handlers.add(new PlacementHandlers.AirPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.FirePlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.GrassPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.DoorPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.BedPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.DoublePlantPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.SpecialBlockPlacementAttemptHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.FlowerPotPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.BlockGrassPathPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.StairBlockPlacementHandler());
        PlacementHandlers.handlers.add(new BlockSolidSubstitutionPlacementHandler());
        PlacementHandlers.handlers.add(new ChestPlacementHandler());
        PlacementHandlers.handlers.add(new WayPointBlockPlacementHandler());
        PlacementHandlers.handlers.add(new RackPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.FallingBlockPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.BannerPlacementHandler());
        PlacementHandlers.handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return true;
        }

        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement((NBTTagCompound)tileEntityData, (World)world, (BlockPos)pos);
            }
            return blockState;
        }

        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (!ChiselAndBitsCheck.isChiselAndBitsBlock(blockState)) {
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            }
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity((NBTTagCompound)tileEntityData, (World)world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class ChestPlacementHandler
    implements IPlacementHandler {
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockChest;
        }

        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement((NBTTagCompound)tileEntityData, (World)world, (BlockPos)pos);
            }
            TileEntity entity = world.func_175625_s(pos);
            Colony colony = ColonyManager.getClosestColony(world, pos);
            if (colony != null && entity instanceof TileEntityChest && colony.getBuildingManager().getBuilding(centerPos) instanceof BuildingWareHouse) {
                BuildingWareHouse.handleBuildingOverChest(pos, (TileEntityChest)entity, world);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return blockState;
        }

        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity((NBTTagCompound)tileEntityData, (World)world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class BlockSolidSubstitutionPlacementHandler
    implements IPlacementHandler {
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockSolidSubstitution;
        }

        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            if (complete ? !world.func_180501_a(pos, blockState, 3) : !world.func_180501_a(pos, newBlockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return newBlockState;
        }

        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(newBlockState));
            return itemList;
        }
    }

    public static class RackPlacementHandler
    implements IPlacementHandler {
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockMinecoloniesRack;
        }

        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            TileEntity entity;
            if (world.func_180495_p(pos).func_177230_c() == ModBlocks.blockRack) {
                return blockState;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement((NBTTagCompound)tileEntityData, (World)world, (BlockPos)pos);
            }
            if ((entity = world.func_175625_s(pos)) instanceof TileEntityChest) {
                BuildingWareHouse.handleBuildingOverChest(pos, (TileEntityChest)entity, world);
            } else if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return blockState;
        }

        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            for (ItemStack stack : PlacementHandlers.getItemsFromTileEntity((NBTTagCompound)tileEntityData, (World)world)) {
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                itemList.add(stack);
            }
            return itemList;
        }
    }

    public static class WayPointBlockPlacementHandler
    implements IPlacementHandler {
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockWaypoint;
        }

        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            world.func_175698_g(pos);
            Colony colony = ColonyManager.getClosestColony(world, pos);
            if (colony != null) {
                if (!complete) {
                    colony.addWayPoint(pos, Blocks.field_150350_a.func_176223_P());
                } else {
                    world.func_175656_a(pos, blockState);
                }
            }
            return blockState;
        }

        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }
}

