/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.coremod.MineColonies;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChunkCapabilityMessage
implements IMessage,
IMessageHandler<UpdateChunkCapabilityMessage, IMessage> {
    private int owningColonyId;
    private int x;
    private int z;
    private List<Integer> closeColonies;

    public UpdateChunkCapabilityMessage() {
    }

    public UpdateChunkCapabilityMessage(@NotNull IColonyTagCapability tagCapability, int x, int z) {
        this.x = x;
        this.z = z;
        this.owningColonyId = tagCapability.getOwningColony();
        this.closeColonies = tagCapability.getAllCloseColonies();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.owningColonyId = buf.readInt();
        int size = buf.readInt();
        this.closeColonies = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.closeColonies.add(buf.readInt());
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        buf.writeInt(this.owningColonyId);
        buf.writeInt(this.closeColonies.size());
        for (int id : this.closeColonies) {
            buf.writeInt(id);
        }
    }

    @Nullable
    public IMessage onMessage(@NotNull UpdateChunkCapabilityMessage message, MessageContext ctx) {
        if (ctx.getClientHandler().field_147300_g != null) {
            Chunk chunk = ctx.getClientHandler().field_147300_g.func_72964_e(message.x, message.z);
            IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
            cap.reset();
            cap.setOwningColony(message.owningColonyId);
            for (int id : message.closeColonies) {
                cap.addColony(id);
            }
        }
        return null;
    }
}

