/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RecallTownhallMessage
extends AbstractMessage<RecallTownhallMessage, IMessage> {
    private int colonyId;
    private int dimension;

    public RecallTownhallMessage() {
    }

    public RecallTownhallMessage(@NotNull BuildingTownHall.View townhall) {
        this.colonyId = townhall.getColony().getID();
        this.dimension = townhall.getColony().getDimension();
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(RecallTownhallMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingTownHall building = colony.getBuildingManager().getTownHall();
            if (building != null) {
                BlockPos location = building.getLocation();
                World world = colony.getWorld();
                for (CitizenData citizenData : colony.getCitizenManager().getCitizens()) {
                    Optional<EntityCitizen> optionalEntityCitizen = citizenData.getCitizenEntity();
                    if (!optionalEntityCitizen.isPresent()) {
                        Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                        citizenData.updateCitizenEntityIfNecessary();
                        optionalEntityCitizen = citizenData.getCitizenEntity();
                    }
                    if (!optionalEntityCitizen.isPresent() || TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), world, location)) continue;
                    LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.workerHuts.recallFail", new Object[0]);
                }
            }
        }
    }
}

