/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RecallCitizenMessage
extends AbstractMessage<RecallCitizenMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int dimension;

    public RecallCitizenMessage() {
    }

    public RecallCitizenMessage(@NotNull AbstractBuildingWorker.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void messageOnServerThread(RecallCitizenMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingWorker building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingWorker.class);
            if (building != null) {
                for (int i = 0; i < building.getAssignedEntities().size(); ++i) {
                    Optional<EntityCitizen> optionalEntityCitizen = building.getAssignedEntities().get(i);
                    CitizenData citizenData = building.getAssignedCitizen().get(i);
                    if (!optionalEntityCitizen.isPresent()) {
                        if (citizenData == null) {
                            Log.getLogger().warn("Citizen is AWOL and citizenData is null!");
                            return;
                        }
                        Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                        citizenData.updateCitizenEntityIfNecessary();
                        optionalEntityCitizen = citizenData.getCitizenEntity();
                    } else if (optionalEntityCitizen.get().field_70173_aa == 0) {
                        EntityCitizen oldCitizen = optionalEntityCitizen.get();
                        List list = player.func_71121_q().func_175644_a(EntityCitizen.class, e -> e.equals((Object)oldCitizen));
                        if (list.isEmpty()) {
                            citizenData.setCitizenEntity(null);
                            citizenData.updateCitizenEntityIfNecessary();
                        } else {
                            citizenData.setCitizenEntity((EntityCitizen)((Object)list.get(0)));
                        }
                    }
                    BlockPos loc = building.getLocation();
                    if (!optionalEntityCitizen.isPresent() || TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) continue;
                    LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.workerHuts.recallFail", new Object[0]);
                }
            }
        }
    }
}

