/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class MarkBuildingDirtyMessage
extends AbstractMessage<MarkBuildingDirtyMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private int dimension;

    public MarkBuildingDirtyMessage() {
    }

    public MarkBuildingDirtyMessage(@NotNull AbstractBuildingView building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(MarkBuildingDirtyMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null) {
            Log.getLogger().warn("MarkBuildingDirtyMessage colony is null");
            return;
        }
        AbstractBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (building == null || building.getTileEntity() == null) {
            Log.getLogger().warn("MarkBuildingDirtyMessage building or tileEntity is null");
            return;
        }
        building.getTileEntity().func_70296_d();
    }
}

