/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.structurize.coremod.management.Structures;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyStylesMessage
extends AbstractMessage<ColonyStylesMessage, IMessage> {
    private boolean allowPlayerSchematics;
    private Map<String, String> md5Map;

    public void fromBytes(@NotNull ByteBuf buf) {
        this.allowPlayerSchematics = buf.readBoolean();
        this.md5Map = ColonyStylesMessage.readMD5MapFromByteBuf(buf);
    }

    @NotNull
    private static Map<String, String> readMD5MapFromByteBuf(@NotNull ByteBuf buf) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String md5 = ByteBufUtils.readUTF8String((ByteBuf)buf);
            map.put(filename, md5);
        }
        return map;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeBoolean(Configurations.gameplay.allowPlayerSchematics);
        ColonyStylesMessage.writeMD5MapToByteBuf(buf);
    }

    private static void writeMD5MapToByteBuf(@NotNull ByteBuf buf) {
        Map md5s = Structures.getMD5s();
        buf.writeInt(md5s.size());
        for (Map.Entry entry : md5s.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getKey()));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getValue()));
        }
    }

    @Override
    protected void messageOnClientThread(ColonyStylesMessage message, MessageContext ctx) {
        Structures.setAllowPlayerSchematics((boolean)message.allowPlayerSchematics);
        Structures.setMD5s(message.md5Map);
    }
}

