/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingSetStyleMessage
extends AbstractMessage<BuildingSetStyleMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private String style;
    private int dimension;

    public BuildingSetStyleMessage() {
    }

    public BuildingSetStyleMessage(@NotNull AbstractBuildingView building, String style) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.style = style;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.style);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(BuildingSetStyleMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuilding building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuilding.class);
            if (building != null) {
                building.setStyle(message.style);
                if (building.getTileEntity() != null) {
                    building.getTileEntity().setStyle(message.style);
                    if (building.getBuildingLevel() > 0) {
                        building.onUpgradeComplete(building.getBuildingLevel());
                    }
                }
            }
        }
    }
}

