/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticleEffectMessage
extends AbstractMessage<BlockParticleEffectMessage, IMessage> {
    public static final int BREAK_BLOCK = -1;
    private BlockPos pos;
    private Block block;
    private int metadata;
    private int side;

    public BlockParticleEffectMessage() {
    }

    public BlockParticleEffectMessage(BlockPos pos, @NotNull IBlockState state, int side) {
        this.pos = pos;
        this.block = state.func_177230_c();
        this.metadata = state.func_177230_c().func_176201_c(state);
        this.side = side;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.block = Block.func_149729_e((int)buf.readInt());
        this.metadata = buf.readInt();
        this.side = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(Block.func_149682_b((Block)this.block));
        buf.writeInt(this.metadata);
        buf.writeInt(this.side);
    }

    @Override
    @Nullable
    protected void messageOnClientThread(BlockParticleEffectMessage message, MessageContext ctx) {
        if (message.side == -1) {
            Minecraft.func_71410_x().field_71452_i.func_180533_a(message.pos, message.block.func_176223_P());
        } else {
            FMLClientHandler.instance().getClient().field_71452_i.func_180532_a(message.pos, EnumFacing.func_82600_a((int)message.side));
        }
    }
}

