/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.network.messages.ChangeFreeToInteractBlockMessage;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ItemScepterPermission
extends AbstractItemMinecolonies {
    private static final String TAG_ITEM_MODE = "scepterMode";
    private static final String TAG_VALUE_MODE_BLOCK = "modeBlock";
    private static final String TAG_VALUE_MODE_LOCATION = "modeLocation";

    public ItemScepterPermission() {
        super("scepterPermission");
        this.func_77656_e(2);
        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        this.field_77777_bU = 1;
    }

    @NotNull
    private static EnumActionResult handleAddBlockType(EntityPlayer playerIn, World worldIn, BlockPos pos, ColonyView colonyView) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(colonyView, block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        MineColonies.getNetwork().sendToServer((IMessage)message);
        return EnumActionResult.SUCCESS;
    }

    @NotNull
    private static EnumActionResult handleAddLocation(EntityPlayer playerIn, World worldIn, BlockPos pos, ColonyView colonyView) {
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(colonyView, pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        MineColonies.getNetwork().sendToServer((IMessage)message);
        return EnumActionResult.SUCCESS;
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ColonyView colonyView;
        if (!worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack scepter = playerIn.func_184586_b(hand);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        if ((colonyView = ColonyManager.getClosestColonyView(worldIn, pos)) == null) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound compound = scepter.func_77978_p();
        return ItemScepterPermission.handleItemAction(compound, playerIn, worldIn, pos, colonyView);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack scepter = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)scepter);
        }
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = scepter.func_77978_p();
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)scepter);
    }

    private static void toggleItemMode(EntityPlayer playerIn, NBTTagCompound compound) {
        String itemMode;
        switch (itemMode = compound.func_74779_i(TAG_ITEM_MODE)) {
            case "modeBlock": {
                compound.func_74778_a(TAG_ITEM_MODE, TAG_VALUE_MODE_LOCATION);
                LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.item.permissionscepter.setmode", "location");
                break;
            }
            default: {
                compound.func_74778_a(TAG_ITEM_MODE, TAG_VALUE_MODE_BLOCK);
                LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.item.permissionscepter.setmode", "block");
            }
        }
    }

    @NotNull
    private static EnumActionResult handleItemAction(NBTTagCompound compound, EntityPlayer playerIn, World worldIn, BlockPos pos, ColonyView colonyView) {
        String tagItemMode;
        switch (tagItemMode = compound.func_74779_i(TAG_ITEM_MODE)) {
            case "modeBlock": {
                return ItemScepterPermission.handleAddBlockType(playerIn, worldIn, pos, colonyView);
            }
            case "modeLocation": {
                return ItemScepterPermission.handleAddLocation(playerIn, worldIn, pos, colonyView);
            }
        }
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return ItemScepterPermission.handleItemAction(compound, playerIn, worldIn, pos, colonyView);
    }
}

