/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.world.World;

public class CraftingGUIBuilding
extends Container {
    private static final int PLAYER_INVENTORY_INITIAL_X_OFFSET = 8;
    private static final int PLAYER_INVENTORY_INITIAL_Y_OFFSET = 84;
    private static final int INVENTORY_OFFSET_EACH = 18;
    private static final int PLAYER_INVENTORY_HOTBAR_OFFSET = 142;
    private static final int X_CRAFT_RESULT = 124;
    private static final int Y_CRAFT_RESULT = 35;
    private static final int X_OFFSET_CRAFTING = 30;
    private static final int Y_OFFSET_CRAFTING = 17;
    private static final int CRAFTING_SLOTS = 5;
    private static final int ADDITIONAL_SLOTS = 5;
    private static final int HOTBAR_START = 32;
    private static final int TOTAL_SLOTS = 41;
    private final InventoryCrafting craftMatrix;
    private final InventoryCraftResult craftResult = new InventoryCraftResult();
    private final World worldObj;
    private final EntityPlayer player;
    private final boolean complete;

    public CraftingGUIBuilding(InventoryPlayer playerInventory, World worldIn, boolean complete) {
        int j;
        int i;
        this.worldObj = worldIn;
        this.player = playerInventory.field_70458_d;
        this.complete = complete;
        this.craftMatrix = complete ? new InventoryCrafting((Container)this, 3, 3) : new InventoryCrafting((Container)this, 2, 2);
        this.func_75146_a((Slot)new SlotCrafting(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35){

            public boolean func_82869_a(EntityPlayer playerIn) {
                return false;
            }
        });
        for (i = 0; i < this.craftMatrix.func_174922_i(); ++i) {
            for (j = 0; j < this.craftMatrix.func_174923_h(); ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * (complete ? 3 : 2), 30 + j * 18, 17 + i * 18){

                    public int func_75219_a() {
                        return 1;
                    }

                    public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                        return ItemStack.field_190927_a;
                    }

                    public ItemStack func_75209_a(int par1) {
                        return ItemStack.field_190927_a;
                    }

                    public boolean func_75214_a(ItemStack par1ItemStack) {
                        return false;
                    }

                    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 142));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    protected final Slot func_75146_a(Slot slotToAdd) {
        return super.func_75146_a(slotToAdd);
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (!this.worldObj.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.player;
            ItemStack itemstack = ItemStack.field_190927_a;
            IRecipe irecipe = CraftingManager.func_192413_b((InventoryCrafting)this.craftMatrix, (World)this.worldObj);
            if (irecipe != null && (irecipe.func_192399_d() || !this.worldObj.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe) || entityplayermp.func_184812_l_())) {
                this.craftResult.func_193056_a(irecipe);
                itemstack = irecipe.func_77572_b(this.craftMatrix);
            }
            this.craftResult.func_70299_a(0, itemstack);
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
        }
        super.func_75130_a(inventoryIn);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType mode, EntityPlayer playerIn) {
        if (slotId >= 1 && slotId < 5 + (this.complete ? 5 : 0)) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                ItemStack dropping = playerIn.field_71071_by.func_70445_o();
                return this.handleSlotClick(slot, dropping);
            }
            return ItemStack.field_190927_a;
        }
        if (mode == ClickType.QUICK_MOVE) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            slot.func_75215_d(copy);
        } else if (slot.func_75211_c().func_190916_E() > 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return slot.func_75211_c().func_77946_l();
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (index <= 5 + (this.complete ? 5 : 0)) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 5 + (this.complete ? 5 : 0), 41 + (this.complete ? 5 : 0), true)) {
                    return ItemStackUtils.EMPTY;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 32) {
                if (!this.func_75135_a(itemstack1, 32, 41 + (this.complete ? 5 : 0), false)) {
                    return ItemStackUtils.EMPTY;
                }
            } else if (index < 41 + (this.complete ? 5 : 0) && !this.func_75135_a(itemstack1, 5 + (this.complete ? 5 : 0), 32, false) || !this.func_75135_a(itemstack1, 5 + (this.complete ? 5 : 0), 41 + (this.complete ? 5 : 0), false)) {
                return null;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStackUtils.EMPTY);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStackUtils.EMPTY;
            }
        }
        return itemstack;
    }

    public List<Slot> getCraftingSlots() {
        if (this.complete) {
            return ImmutableList.of((Object)this.func_75139_a(1), (Object)this.func_75139_a(2), (Object)this.func_75139_a(3), (Object)this.func_75139_a(4), (Object)this.func_75139_a(5), (Object)this.func_75139_a(6), (Object)this.func_75139_a(7), (Object)this.func_75139_a(8), (Object)this.func_75139_a(9));
        }
        return ImmutableList.of((Object)this.func_75139_a(1), (Object)this.func_75139_a(2), (Object)this.func_75139_a(3), (Object)this.func_75139_a(4));
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public World getWorldObj() {
        return this.worldObj;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

