/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobFindTree
extends AbstractPathJob {
    private static final double TIE_BREAKER = 0.951;
    private final BlockPos hutLocation;
    private final List<ItemStorage> treesToNotCut;
    private final Colony colony;

    public PathJobFindTree(World world, @NotNull BlockPos start, BlockPos home, int range, List<ItemStorage> treesToCut, Colony colony) {
        super(world, start, start, range, new TreePathResult());
        this.treesToNotCut = treesToCut;
        this.hutLocation = home;
        this.colony = colony;
    }

    @Override
    @NotNull
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.hutLocation.func_177958_n();
        int dy = pos.func_177956_o() - this.hutLocation.func_177956_o();
        int dz = pos.func_177952_p() - this.hutLocation.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.951;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return n.parent != null && this.isNearTree(n);
    }

    private boolean isNearTree(@NotNull Node n) {
        if (n.pos.func_177958_n() == n.parent.pos.func_177958_n()) {
            int dz = n.pos.func_177952_p() > n.parent.pos.func_177952_p() ? 1 : -1;
            return this.isTree(n.pos.func_177982_a(0, 0, dz)) || this.isTree(n.pos.func_177982_a(-1, 0, 0)) || this.isTree(n.pos.func_177982_a(1, 0, 0));
        }
        int dx = n.pos.func_177958_n() > n.parent.pos.func_177958_n() ? 1 : -1;
        return this.isTree(n.pos.func_177982_a(-dx, 0, 0)) || this.isTree(n.pos.func_177982_a(0, 0, -1)) || this.isTree(n.pos.func_177982_a(0, 0, 1));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos, this.treesToNotCut) && Tree.checkIfInColonyAndNotInBuilding(pos, this.colony)) {
            this.getResult().treeLocation = pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }

    @Override
    protected boolean isPassable(@NotNull IBlockState block) {
        return super.isPassable(block) || block.func_185904_a() == Material.field_151584_j;
    }

    public static class TreePathResult
    extends PathResult {
        public BlockPos treeLocation;
    }
}

