/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class CitizenStuckHandler {
    private final EntityCitizen citizen;
    private boolean triedMovingAway = false;
    private int stuckTime = 0;

    public CitizenStuckHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public void onUpdate() {
        if (this.citizen.field_70173_aa % 20 == 0) {
            this.checkIfStuck();
            if (this.citizen.field_70173_aa % 2400 == 0) {
                this.triedMovingAway = false;
            }
        }
    }

    public boolean isStuck() {
        return this.stuckTime >= 5 + this.citizen.getRandom().nextInt(5) && this.triedMovingAway;
    }

    private void checkIfStuck() {
        if (this.citizen.getCurrentPosition() == null) {
            this.citizen.setCurrentPosition(this.citizen.func_180425_c());
            return;
        }
        if (this.citizen.getNavigator().getDestination() == null || this.citizen.getNavigator().getDestination().func_177954_c(this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v) < 6.0) {
            return;
        }
        if (!new AxisAlignedBB(this.citizen.getCurrentPosition()).func_72321_a(1.0, 1.0, 1.0).func_72326_a(new AxisAlignedBB(this.citizen.func_180425_c())) && !this.triedMovingAway) {
            this.stuckTime = 0;
            this.citizen.setCurrentPosition(this.citizen.func_180425_c());
            return;
        }
        ++this.stuckTime;
        if (this.stuckTime >= 5 + this.citizen.getRandom().nextInt(5) && !this.triedMovingAway) {
            this.triedMovingAway = true;
            this.citizen.getNavigator().moveAwayFromXYZ(this.citizen.getCurrentPosition(), this.citizen.getRandom().nextInt(6), 1.0);
            return;
        }
        if (this.stuckTime >= 120) {
            if (this.citizen.getNavigator().getDestination().func_177954_c(this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v) < 6.0 || (double)this.citizen.getNavigator().getDestination().func_177956_o() - this.citizen.field_70163_u > 2.0) {
                this.stuckTime = 0;
                return;
            }
            this.triedMovingAway = false;
            BlockPos destination = BlockPosUtil.getFloor(this.citizen.getNavigator().getDestination().func_177984_a(), CompatibilityUtils.getWorld((Entity)this.citizen));
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(CompatibilityUtils.getWorld((Entity)this.citizen), destination, 1, 1, 1, 3, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
            WorkerUtil.setSpawnPoint(spawnPoint, this.citizen);
            if (this.citizen.getCitizenColonyHandler().getColony() != null) {
                Log.getLogger().info("Teleported stuck citizen " + this.citizen.func_70005_c_() + " from colony: " + this.citizen.getCitizenColonyHandler().getColonyId() + " to target location");
            }
            this.stuckTime = 0;
        }
        this.citizen.setCurrentPosition(this.citizen.func_180425_c());
    }
}

