/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.FieldDataModifier;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.util.ChatSpamFilter;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CitizenHappinessHandler {
    @NotNull
    protected final ChatSpamFilter chatSpamFilter;
    public static final int MAX_DAYS_WITHOUT_HOUSE = 30;
    public static final int MAX_HOUSE_PENALTY = 5;
    public static final double HOUSE_MODIFIER_POSITIVE = 0.5;
    public static final int COMPLAIN_DAYS_WITHOUT_HOUSE = 7;
    public static final int DEMANDS_DAYS_WITHOUT_HOUSE = 14;
    public static final int MAX_DAYS_WITHOUT_JOB = 30;
    public static final int COMPLAIN_DAYS_WITHOUT_JOB = 7;
    public static final int DEMANDS_DAYS_WITHOUT_JOB = 14;
    public static final int MAX_JOB_PENALTY = 5;
    public static final double JOB_MODIFIER_POSITIVE = 0.5;
    public static final int FOOD_MODIFIER_MAX = -2;
    public static final int FOOD_MODIFIER_MIN = -1;
    public static final double FOOD_MODIFIER_POSITIVE = 0.5;
    public static final int FIELD_MAX_DAYS_MODIFIER = 30;
    public static final double FIELD_MODIFIER_MAX = -0.75;
    public static final double FIELD_MODIFIER_MIN = -0.15;
    public static final double FIELD_MODIFIER_POSITIVE = 0.2;
    public static final double NO_FIELD_MODIFIER = -3.0;
    public static final int NO_FIELDS_COMPLAINS_DAYS = 7;
    public static final int DAMAGE_MODIFIER_MAX = -2;
    public static final int DAMAGE_MODIFIER_MID = -1;
    public static final double DAMAGE_MODIFIER_MIN = -0.5;
    public static final double DAMAGE_LOWEST_POINT = 0.25;
    public static final double DAMAGE_MEDIUM_POINT = 0.5;
    public static final double DAMAGE_HIGHEST_POINT = 0.75;
    public static final int MAX_HAPPINESS = 10;
    public static final int MIN_HAPPINESS = 1;
    public static final int BASE_HAPPINESS = 8;
    public static final int NO_TOOLS_MODIFIER = 3;
    public static final int NO_TOOLS_COMPLAINS_DAYS = 7;
    public static final int NO_TOOLS_DEMANDS_DAYS = 14;
    public static final int NO_TOOLS_MAX_DAYS_MODIFIER = 30;
    private final CitizenData citizen;
    private double baseHappiness;
    private double foodModifier;
    private double damageModifier;
    private double houseModifier;
    private int numberOfDaysWithoutHouse;
    private double jobModifier;
    private int numberOfDaysWithoutJob;
    private double farmerModifier;
    private boolean hasNoFields;
    private final Map<BlockPos, FieldDataModifier> fieldModifier = new HashMap<BlockPos, FieldDataModifier>();
    private final Map<IToolType, Integer> needsTool = new HashMap<IToolType, Integer>();
    private double noToolModifier;

    public CitizenHappinessHandler(CitizenData citizen) {
        this.citizen = citizen;
        this.baseHappiness = 8.0;
        this.foodModifier = 0.0;
        this.damageModifier = 0.0;
        this.houseModifier = 0.0;
        this.numberOfDaysWithoutHouse = 0;
        this.jobModifier = 0.0;
        this.numberOfDaysWithoutJob = 0;
        this.farmerModifier = 0.0;
        this.hasNoFields = false;
        this.needsTool.clear();
        this.chatSpamFilter = new ChatSpamFilter(citizen);
    }

    public void setFoodModifier(boolean eatFood) {
        this.foodModifier = !eatFood ? (this.citizen.getSaturation() < 3.0 ? -2.0 : -1.0) : 0.0;
        this.citizen.markDirty();
    }

    public void processDailyHappiness(boolean hasHouse, boolean hasJob) {
        if (this.citizen.getColony().getColonyHappinessManager().getLockedHappinessModifier().isPresent()) {
            return;
        }
        if (!hasHouse) {
            ++this.numberOfDaysWithoutHouse;
            if (this.numberOfDaysWithoutHouse > 14) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.demandsHouse", this.citizen.getName());
            } else if (this.numberOfDaysWithoutHouse > 7) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.noHouse", this.citizen.getName());
            }
        } else {
            this.numberOfDaysWithoutHouse = 0;
        }
        this.setHomeModifier(hasHouse);
        if (!hasJob) {
            ++this.numberOfDaysWithoutJob;
            if (this.numberOfDaysWithoutJob > 14) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.demandsJob", this.citizen.getName());
            } else if (this.numberOfDaysWithoutJob > 7) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.noJob", this.citizen.getName());
            }
        } else {
            this.numberOfDaysWithoutJob = 0;
        }
        this.setJobModifier(hasJob);
        this.farmerModifier = 0.0;
        this.hasNoFields = true;
        for (FieldDataModifier fieldDataModifier : this.fieldModifier.values()) {
            if (fieldDataModifier.isCanFarm()) {
                this.farmerModifier += 0.2;
                this.hasNoFields = false;
                continue;
            }
            fieldDataModifier.increaseInactiveDays();
            if (fieldDataModifier.getInactiveDays() < 7) {
                this.farmerModifier += -0.15;
                continue;
            }
            this.farmerModifier += (double)fieldDataModifier.getInactiveDays() / 30.0 * -0.75 + -0.15;
        }
        if (this.hasNoFields && this.citizen.getJob() instanceof JobFarmer) {
            this.farmerModifier = -3.0;
        }
        this.noToolModifier = 0.0;
        for (Map.Entry entry : this.needsTool.entrySet()) {
            int numDays = (Integer)entry.getValue() + 1;
            IToolType toolType = (IToolType)entry.getKey();
            this.needsTool.put(toolType, numDays);
            if (numDays > 14) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.noTool", this.citizen.getName(), toolType.getDisplayName());
            } else if (numDays > 7) {
                this.chatSpamFilter.talkWithoutSpam("entity.citizen.demandsTool", this.citizen.getName(), toolType.getDisplayName());
            }
            this.noToolModifier += (double)numDays / 30.0 * 3.0;
        }
        this.citizen.markDirty();
    }

    public void setSaturated() {
        this.foodModifier = 0.5;
    }

    public void setDamageModifier() {
        Optional<EntityCitizen> entityCitizen = this.citizen.getCitizenEntity();
        if (entityCitizen.isPresent()) {
            double health = entityCitizen.get().func_110143_aJ() / entityCitizen.get().func_110138_aP();
            if (health < 0.25) {
                this.damageModifier = -2.0;
            } else if (health < 0.5) {
                this.damageModifier = -1.0;
            } else if (health < 0.75) {
                this.damageModifier = -0.5;
            }
            this.citizen.markDirty();
        }
        this.citizen.markDirty();
    }

    public void setNoFieldForFarmerModifier(BlockPos pos, boolean canFarm) {
        FieldDataModifier field = this.fieldModifier.get(pos);
        if (field == null) {
            field = new FieldDataModifier();
            this.fieldModifier.put(pos, field);
        }
        field.isCanFarm(canFarm);
        this.citizen.markDirty();
    }

    public void setNoFieldsToFarm() {
        this.hasNoFields = true;
    }

    public void setNeedsATool(@NotNull IToolType toolType, boolean needs) {
        if (needs) {
            if (!this.needsTool.containsKey(toolType)) {
                this.needsTool.put(toolType, 0);
            }
        } else {
            this.needsTool.remove(toolType);
        }
        this.citizen.markDirty();
    }

    public void setHomeModifier(boolean hasHouse) {
        this.houseModifier = hasHouse ? 0.5 : 5.0 * ((double)this.numberOfDaysWithoutHouse / 30.0) * -1.0;
        this.citizen.markDirty();
    }

    public void setJobModifier(boolean hasJob) {
        this.jobModifier = hasJob ? 0.5 : 5.0 * ((double)this.numberOfDaysWithoutHouse / 30.0) * -1.0;
        this.citizen.markDirty();
    }

    public double getHappiness() {
        if (this.citizen.getColony().getColonyHappinessManager().getLockedHappinessModifier().isPresent()) {
            return this.citizen.getColony().getColonyHappinessManager().getLockedHappinessModifier().get();
        }
        double value = this.baseHappiness + this.foodModifier + this.damageModifier + this.houseModifier + this.jobModifier + this.farmerModifier + this.noToolModifier;
        if (value > 10.0) {
            value = 10.0;
        } else if (value < 1.0) {
            value = 1.0;
        }
        return value;
    }

    public double getFoodModifier() {
        return this.foodModifier;
    }

    public double getDamageModifier() {
        return this.damageModifier;
    }

    public double getHouseModifier() {
        return this.houseModifier;
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound taskCompound = new NBTTagCompound();
        taskCompound.func_74780_a("base", this.baseHappiness);
        taskCompound.func_74780_a("foodModifier", this.foodModifier);
        taskCompound.func_74780_a("damageModifier", this.damageModifier);
        taskCompound.func_74780_a("houseModifier", this.houseModifier);
        taskCompound.func_74768_a("numberOfDaysWithoutHouse", this.numberOfDaysWithoutHouse);
        taskCompound.func_74780_a("jobModifier", this.jobModifier);
        taskCompound.func_74768_a("numberOfDaysWithoutJob", this.numberOfDaysWithoutJob);
        taskCompound.func_74757_a("hasNoFields", this.hasNoFields);
        NBTTagList fieldsTagList = new NBTTagList();
        for (Map.Entry<BlockPos, FieldDataModifier> entry : this.fieldModifier.entrySet()) {
            BlockPos pos = entry.getKey();
            FieldDataModifier field = entry.getValue();
            NBTTagCompound fieldCompound = new NBTTagCompound();
            fieldCompound.func_74768_a("daysinactive", field.getInactiveDays());
            fieldCompound.func_74757_a("canfarm", field.isCanFarm());
            NBTTagList containerTagList = new NBTTagList();
            containerTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            fieldCompound.func_74782_a("id", (NBTBase)containerTagList);
            fieldsTagList.func_74742_a((NBTBase)fieldCompound);
        }
        taskCompound.func_74782_a("fields", (NBTBase)fieldsTagList);
        NBTTagList noToolsTagList = new NBTTagList();
        for (Map.Entry<IToolType, Integer> entry : this.needsTool.entrySet()) {
            IToolType toolType = entry.getKey();
            int numDays = entry.getValue();
            NBTTagCompound noToolsCompound = new NBTTagCompound();
            noToolsCompound.func_74768_a("numberOfDaysNoTools", numDays);
            noToolsCompound.func_74778_a("toolType", toolType.getName());
            noToolsTagList.func_74742_a((NBTBase)noToolsCompound);
        }
        taskCompound.func_74782_a("fields", (NBTBase)fieldsTagList);
        compound.func_74782_a("happiness", (NBTBase)taskCompound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound containerCompound;
        NBTTagCompound tagCompound = compound.func_74775_l("happiness");
        this.baseHappiness = tagCompound.func_74769_h("base");
        this.foodModifier = tagCompound.func_74769_h("foodModifier");
        this.damageModifier = tagCompound.func_74769_h("damageModifier");
        this.houseModifier = tagCompound.func_74769_h("houseModifier");
        this.numberOfDaysWithoutHouse = tagCompound.func_74762_e("numberOfDaysWithoutHouse");
        this.jobModifier = tagCompound.func_74769_h("jobModifier");
        this.numberOfDaysWithoutJob = tagCompound.func_74762_e("numberOfDaysWithoutJob");
        this.hasNoFields = tagCompound.func_74767_n("hasNoFields");
        NBTTagList fieldTagList = tagCompound.func_150295_c("fields", 10);
        for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
            FieldDataModifier field = new FieldDataModifier();
            containerCompound = fieldTagList.func_150305_b(i);
            field.setInactiveDays(containerCompound.func_74762_e("daysinactive"));
            field.isCanFarm(containerCompound.func_74767_n("canfarm"));
            NBTTagList blockPosTagList = containerCompound.func_150295_c("id", 10);
            NBTTagCompound blockPoCompound = blockPosTagList.func_150305_b(0);
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)blockPoCompound);
            this.fieldModifier.put(pos, field);
        }
        NBTTagList noToolsTagList = tagCompound.func_150295_c("noTools", 10);
        for (int i = 0; i < noToolsTagList.func_74745_c(); ++i) {
            containerCompound = noToolsTagList.func_150305_b(i);
            int numDays = containerCompound.func_74762_e("numberOfDaysNoTools");
            IToolType toolType = ToolType.getToolType(containerCompound.func_74779_i("toolType"));
            this.needsTool.put(toolType, numDays);
        }
        if (this.baseHappiness == 0.0) {
            this.baseHappiness = 8.0;
        }
    }

    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        buf.writeDouble(this.getFoodModifier());
        buf.writeDouble(this.getDamageModifier());
        buf.writeDouble(this.getHouseModifier());
        buf.writeDouble(this.jobModifier);
        buf.writeDouble(this.farmerModifier);
        buf.writeDouble(this.noToolModifier);
    }
}

