/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Objects;
import net.minecraft.util.text.TextComponentBase;
import org.jetbrains.annotations.NotNull;

public class ChatSpamFilter {
    protected static final int BASE_TIMEOUT = 600;
    protected static final int MAX_TIMEOUT = 12000;
    private final CitizenData citizenData;
    private int speechDelay = 0;
    @NotNull
    private String speechDelayString = "";
    private int speechRepeat = 0;

    public ChatSpamFilter(CitizenData citizenData) {
        this.citizenData = citizenData;
    }

    public void requestTextComponentWithoutSpam(@NotNull TextComponentBase chat) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", chat);
    }

    public void talkWithoutSpam(String key, Object ... chat) {
        if (!this.citizenData.getCitizenEntity().isPresent()) {
            return;
        }
        EntityCitizen worker = this.citizenData.getCitizenEntity().get();
        String curstring = key + this.getStringOfChat(chat);
        if (Objects.equals(this.speechDelayString, curstring)) {
            if (this.speechDelay > worker.getOffsetTicks()) {
                return;
            }
            if (600 << this.speechRepeat < 12000) {
                ++this.speechRepeat;
            }
        } else {
            this.speechRepeat = 0;
        }
        worker.getCitizenChatHandler().sendLocalizedChat(key, chat);
        this.speechDelayString = key + this.getStringOfChat(chat);
        this.speechDelay = Math.min(600 << this.speechRepeat, 12000) + worker.getOffsetTicks();
    }

    public String getStringOfChat(Object ... chat) {
        if (chat.length == 0) {
            return "";
        }
        StringBuilder tempString = new StringBuilder();
        for (Object object : chat) {
            if (object instanceof TextComponentBase) {
                tempString.append(((TextComponentBase)object).func_150260_c());
                continue;
            }
            tempString.append(object);
        }
        return tempString.toString();
    }

    public void requestTextStringWithoutSpam(@NotNull String chat) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", chat);
    }
}

