/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.coremod.entity.ai.util.AIState;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AITarget {
    @Nullable
    private final AIState state;
    @NotNull
    private final BooleanSupplier predicate;
    @NotNull
    private final Supplier<AIState> action;
    private boolean okayToEat;

    public AITarget(@NotNull Supplier<AIState> action, boolean isOkayToEat) {
        this(() -> true, isOkayToEat, action);
    }

    public AITarget(@NotNull BooleanSupplier predicate, boolean isOkayToEat, @NotNull Supplier<AIState> action) {
        this(null, isOkayToEat, predicate, action);
    }

    public AITarget(@Nullable AIState state, boolean isOkayToEat, @NotNull BooleanSupplier predicate, @NotNull Supplier<AIState> action) {
        this.state = state;
        this.predicate = predicate;
        this.action = action;
        this.okayToEat = isOkayToEat;
    }

    public AITarget(@NotNull BooleanSupplier predicate, @Nullable AIState state, boolean isOkayToEat) {
        this(null, isOkayToEat, predicate, () -> state);
    }

    public AITarget(@NotNull AIState predicateState, @Nullable AIState state, boolean isOkayToEat) {
        this(predicateState, isOkayToEat, () -> state);
    }

    public AITarget(@Nullable AIState state, boolean isOkayToEat, @NotNull Supplier<AIState> action) {
        this(state, isOkayToEat, () -> true, action);
    }

    @Nullable
    public AIState getState() {
        return this.state;
    }

    public boolean test() {
        return this.predicate.getAsBoolean();
    }

    public AIState apply() {
        return this.action.get();
    }

    public boolean isOkayToEat() {
        return this.okayToEat;
    }
}

