/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.entity.ai.mobs.aitasks.EntityAIAttackArcher;
import com.minecolonies.coremod.entity.ai.mobs.aitasks.EntityAIRaiderAttackMelee;
import com.minecolonies.coremod.entity.ai.mobs.aitasks.EntityAIWalkToRandomHuts;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.AbstractEntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.pirates.AbstractEntityPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import com.minecolonies.coremod.items.ModItems;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class MobSpawnUtils {
    private MobSpawnUtils() {
    }

    public static void setMobAttributes(EntityLiving mob, Colony colony) {
        mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        mob.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        if (mob instanceof EntityChiefBarbarian || mob instanceof EntityCaptainPirate) {
            mob.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        } else {
            mob.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.5);
        }
        mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(MobSpawnUtils.getHealthBasedOnRaidLevel(colony));
    }

    private static double getHealthBasedOnRaidLevel(Colony colony) {
        if (colony != null) {
            int raidLevel = (int)((double)MobEventsUtils.getColonyRaidLevel(colony) * 0.2);
            return Math.max(5.0, (5.0 + (double)raidLevel) * ((double)Configurations.gameplay.barbarianHordeDifficulty * 0.1));
        }
        return 5.0;
    }

    public static void setMobAI(AbstractEntityMinecoloniesMob mob) {
        mob.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)mob));
        mob.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWalkToRandomHuts(mob, 2.0));
        mob.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityPlayer.class, true));
        mob.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityCitizen.class, true));
        mob.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)mob, EntityPlayer.class, 8.0f));
        if (mob instanceof EntityArcherBarbarian || mob instanceof EntityArcherPirate) {
            mob.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackArcher((EntityCreature)mob));
        } else {
            mob.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRaiderAttackMelee(mob));
        }
    }

    public static void spawn(ResourceLocation entityToSpawn, int numberOfSpawns, BlockPos spawnLocation, World world) {
        if (spawnLocation != null && entityToSpawn != null && world != null) {
            int x = spawnLocation.func_177958_n();
            int y = BlockPosUtil.getFloor(spawnLocation, world).func_177956_o();
            int z = spawnLocation.func_177952_p();
            IntStream.range(0, numberOfSpawns).forEach(theInteger -> {
                AbstractEntityBarbarian entity = (AbstractEntityBarbarian)EntityList.func_188429_b((ResourceLocation)entityToSpawn, (World)world);
                if (entity != null) {
                    MobSpawnUtils.setEquipment(entity);
                    entity.func_70080_a(x, (double)y + 1.0, z, (float)MathHelper.func_76138_g((double)(world.field_73012_v.nextDouble() * 360.0)), 0.0f);
                    CompatibilityUtils.spawnEntity(world, (Entity)entity);
                }
            });
        }
    }

    public static void setEquipment(AbstractEntityMinecoloniesMob mob) {
        if (mob instanceof EntityBarbarian) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
        } else if (mob instanceof EntityArcherBarbarian || mob instanceof EntityArcherPirate) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        } else if (mob instanceof EntityChiefBarbarian) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.chiefSword));
            mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
        } else if (mob instanceof AbstractEntityPirate) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.scimitar));
            if (mob instanceof EntityCaptainPirate) {
                if (new Random().nextBoolean()) {
                    mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.pirateHelmet_1));
                    mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.pirateChest_1));
                    mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.pirateLegs_1));
                    mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.pirateBoots_1));
                } else {
                    mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.pirateHelmet_2));
                    mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.pirateChest_2));
                    mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.pirateLegs_2));
                    mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.pirateBoots_2));
                }
            }
        }
    }
}

