/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import com.minecolonies.coremod.entity.ai.mobs.util.MobSpawnUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BarbarianEventUtils {
    private BarbarianEventUtils() {
    }

    public static void barbarianEvent(World world, Colony colony, BlockPos target, int raidNumber, MobEventsUtils.Horde horde) {
        BlockPos targetSpawnPoint = target;
        if (BlockPosUtil.getFloor(targetSpawnPoint, 0, world) == null) {
            targetSpawnPoint = new BlockPos(targetSpawnPoint.func_177958_n(), colony.getCenter().func_177956_o(), targetSpawnPoint.func_177952_p());
            BarbarianEventUtils.buildPlatform(targetSpawnPoint, world);
        }
        LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "event.minecolonies.raidMessage" + raidNumber, colony.getName());
        MobSpawnUtils.spawn(ColonyConstants.BARBARIAN, horde.numberOfRaiders, targetSpawnPoint, world);
        MobSpawnUtils.spawn(ColonyConstants.ARCHER, horde.numberOfArchers, targetSpawnPoint, world);
        MobSpawnUtils.spawn(ColonyConstants.CHIEF, horde.numberOfBosses, targetSpawnPoint, world);
    }

    private static void buildPlatform(BlockPos target, World world) {
        IBlockState platformBlock = Blocks.field_150376_bx.func_176223_P();
        for (int z = 0; z < 5; ++z) {
            for (int x = 0; x < 5; ++x) {
                int sum = x * x + z * z;
                if (sum >= 6) continue;
                world.func_175656_a(new BlockPos(target.func_177958_n() + x, target.func_177956_o() - 1, target.func_177952_p() + z), platformBlock);
                world.func_175656_a(new BlockPos(target.func_177958_n() + x, target.func_177956_o() - 1, target.func_177952_p() - z), platformBlock);
                world.func_175656_a(new BlockPos(target.func_177958_n() - x, target.func_177956_o() - 1, target.func_177952_p() + z), platformBlock);
                world.func_175656_a(new BlockPos(target.func_177958_n() - x, target.func_177956_o() - 1, target.func_177952_p() - z), platformBlock);
            }
        }
    }
}

