/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAISleep
extends EntityAIBase {
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private boolean wokeUp = true;

    public EntityAISleep(EntityCitizen citizen) {
        this.func_75248_a(1);
        this.citizen = citizen;
    }

    public boolean func_75250_a() {
        return this.citizen.getDesiredActivity() == DesiredActivity.SLEEP && this.citizen.getCitizenColonyHandler().isAtHome() || !this.wokeUp;
    }

    public boolean func_75253_b() {
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.wokeUp = !this.citizen.getCitizenData().isAsleep();
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            this.wokeUp = false;
            Colony colony = this.citizen.getCitizenColonyHandler().getColony();
            if (colony == null || colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf()) == null) {
                return true;
            }
            if (this.usedBed == null) {
                AbstractBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf());
                if (hut instanceof BuildingHome) {
                    for (BlockPos pos : ((BuildingHome)hut).getBedList()) {
                        World world = this.citizen.field_70170_p;
                        IBlockState state = world.func_180495_p(pos);
                        if ((state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos)).func_177230_c() != Blocks.field_150324_C || ((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD)) continue;
                        this.usedBed = pos;
                        this.citizen.field_70170_p.func_180501_a(pos, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true)), 3);
                        BlockPos feetPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
                        IBlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
                        if (feetState.func_177230_c() == Blocks.field_150324_C) {
                            this.citizen.field_70170_p.func_180501_a(feetPos, feetState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        return true;
                    }
                }
                this.usedBed = this.citizen.func_180486_cf();
            } else if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 1)) {
                this.citizen.getCitizenSleepHandler().trySleep(this.usedBed);
                return true;
            }
            return true;
        }
        this.citizen.getCitizenSleepHandler().onWakeUp();
        if (this.usedBed != null) {
            IBlockState state = this.citizen.field_70170_p.func_180495_p(this.usedBed);
            if (state.func_177230_c() == Blocks.field_150324_C) {
                IBlockState headState = this.citizen.field_70170_p.func_180495_p(this.usedBed);
                this.citizen.field_70170_p.func_180501_a(this.usedBed, headState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
                BlockPos feetPos = this.usedBed.func_177972_a(((EnumFacing)headState.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
                IBlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
                if (feetState.func_177230_c() == Blocks.field_150324_C) {
                    this.citizen.field_70170_p.func_180501_a(feetPos, feetState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
            this.usedBed = null;
        }
        this.wokeUp = true;
        return false;
    }

    public void func_75249_e() {
        this.citizen.getCitizenStatusHandler().setStatus(Status.SLEEPING);
    }

    public void func_75246_d() {
    }
}

