/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.util.ChatSpamFilter;
import com.minecolonies.coremod.network.messages.ItemParticleEffectMessage;
import com.minecolonies.coremod.util.SoundUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityAIEatTask
extends EntityAIBase {
    private static final int MINUTES_BETWEEN_FOOD_CHECKS = 2;
    private static final int MINUTES_WAITING_TIME = 2;
    private static final int MIN_DISTANCE_TO_RESTAURANT = 5;
    private static final int PLACE_TO_EAT_DISTANCE = 5;
    private static final int REQUIRED_TIME_TO_EAT = 5;
    protected ChatSpamFilter chatSpamFilter;
    private final EntityCitizen citizen;
    private STATE currentState = STATE.IDLE;
    private int waitingTicks = 0;
    private int foodSlot = -1;
    private BlockPos placeToPath;

    public EntityAIEatTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        if (this.currentState != STATE.IDLE) {
            return true;
        }
        CitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null || this.citizen.getCitizenData().getSaturation() >= 7.0 || !this.citizen.isOkayToEat() && this.citizen.getCitizenData().getSaturation() > 0.0) {
            return false;
        }
        if (citizenData.getSaturation() <= 5.0) {
            ++this.waitingTicks;
            return this.waitingTicks >= 2400 || this.citizen.getCitizenData().getSaturation() < 3.0 || citizenData.getJob() == null;
        }
        return false;
    }

    public void func_75246_d() {
        CitizenData citizenData;
        if (this.chatSpamFilter == null) {
            this.chatSpamFilter = new ChatSpamFilter(this.citizen.getCitizenData());
        }
        if ((citizenData = this.citizen.getCitizenData()) == null) {
            return;
        }
        switch (this.currentState) {
            case CHECK_FOR_FOOD: {
                this.currentState = this.checkForFood(citizenData);
                return;
            }
            case SEARCH_RESTAURANT: {
                this.currentState = this.searchRestaurant(citizenData);
                return;
            }
            case GO_TO_RESTAURANT: {
                this.currentState = this.goToRestaurant();
                return;
            }
            case WAIT_FOR_FOOD: {
                this.currentState = this.waitForFood(citizenData);
                return;
            }
            case FIND_PLACE_TO_EAT: {
                this.currentState = this.findPlaceToEat();
                return;
            }
            case GET_FOOD_YOURSELF: {
                this.currentState = this.getFoodYourself();
                return;
            }
            case EAT: {
                this.currentState = this.eat(citizenData);
                return;
            }
        }
        this.reset();
    }

    private STATE eat(CitizenData citizenData) {
        if (this.foodSlot == -1) {
            return STATE.WAIT_FOR_FOOD;
        }
        ItemStack stack = citizenData.getInventory().func_70301_a(this.foodSlot);
        if (!ItemStackUtils.ISFOOD.test(stack)) {
            return STATE.WAIT_FOR_FOOD;
        }
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, stack);
        if (this.waitingTicks % 10 == 0) {
            this.citizen.func_184609_a(EnumHand.MAIN_HAND);
            this.citizen.func_184185_a(SoundEvents.field_187537_bA, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.getRandom()));
            MineColonies.getNetwork().sendToAllTracking((IMessage)new ItemParticleEffectMessage(this.citizen.func_184614_ca(), this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v, this.citizen.field_70125_A, this.citizen.field_70177_z, this.citizen.func_70047_e()), (Entity)this.citizen);
        }
        ++this.waitingTicks;
        if (this.waitingTicks < 100) {
            return STATE.EAT;
        }
        ItemFood itemFood = (ItemFood)stack.func_77973_b();
        citizenData.increaseSaturation((double)itemFood.func_150905_g(stack) / 2.0);
        citizenData.getInventory().func_70298_a(this.foodSlot, 1);
        citizenData.markDirty();
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        if (citizenData.getSaturation() < 10.0 && !stack.func_190926_b()) {
            this.waitingTicks = 0;
            return STATE.EAT;
        }
        return STATE.IDLE;
    }

    private STATE getFoodYourself() {
        if (this.placeToPath == null) {
            return STATE.SEARCH_RESTAURANT;
        }
        Colony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return STATE.IDLE;
        }
        BlockPos restaurant = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (restaurant == null) {
            return STATE.SEARCH_RESTAURANT;
        }
        AbstractBuilding cookBuilding = colony.getBuildingManager().getBuilding(restaurant);
        if (cookBuilding instanceof BuildingCook) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)cookBuilding.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ItemStackUtils.ISFOOD, 2, (IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()));
            return STATE.WAIT_FOR_FOOD;
        }
        return STATE.IDLE;
    }

    private STATE findPlaceToEat() {
        if (this.placeToPath == null) {
            Vec3d placeToEat = RandomPositionGenerator.func_191377_b((EntityCreature)this.citizen, (int)5, (int)0);
            if (placeToEat == null) {
                this.waitingTicks = 0;
                return STATE.EAT;
            }
            this.placeToPath = new BlockPos(placeToEat);
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 5)) {
            this.waitingTicks = 0;
            return STATE.EAT;
        }
        return STATE.FIND_PLACE_TO_EAT;
    }

    private STATE waitForFood(CitizenData citizenData) {
        Colony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (this.placeToPath == null) {
            return STATE.SEARCH_RESTAURANT;
        }
        if (BlockPosUtil.getDistance2D(this.placeToPath, this.citizen.func_180425_c()) > 5L) {
            return STATE.GO_TO_RESTAURANT;
        }
        STATE state = this.checkForFood(citizenData);
        if (state == STATE.EAT) {
            return STATE.FIND_PLACE_TO_EAT;
        }
        if (state == STATE.IDLE) {
            this.reset();
            return STATE.IDLE;
        }
        ++this.waitingTicks;
        if (this.waitingTicks > 2400) {
            this.waitingTicks = 0;
            return STATE.GET_FOOD_YOURSELF;
        }
        return STATE.WAIT_FOR_FOOD;
    }

    private STATE goToRestaurant() {
        if (this.placeToPath == null) {
            return STATE.SEARCH_RESTAURANT;
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 5)) {
            return STATE.WAIT_FOR_FOOD;
        }
        return STATE.SEARCH_RESTAURANT;
    }

    private STATE searchRestaurant(CitizenData citizenData) {
        Colony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestRestaurant(this.citizen);
        if (this.placeToPath == null) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.ai.noRestaurant", new Object[0]);
            return STATE.CHECK_FOR_FOOD;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().resetAIAfterEating();
        }
        return STATE.GO_TO_RESTAURANT;
    }

    private STATE checkForFood(CitizenData citizenData) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, ItemStackUtils.ISFOOD);
        if (slot == -1) {
            citizenData.getCitizenHappinessHandler().setFoodModifier(false);
            if ((citizenData.getSaturation() < 3.0 || this.citizen.isIdlingAtJob()) && citizenData.getSaturation() < 7.0) {
                return STATE.SEARCH_RESTAURANT;
            }
            this.reset();
            return STATE.IDLE;
        }
        this.foodSlot = slot;
        return STATE.EAT;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.foodSlot = -1;
        this.citizen.func_184597_cx();
        this.citizen.func_184602_cy();
        this.citizen.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        this.placeToPath = null;
        this.currentState = STATE.CHECK_FOR_FOOD;
    }

    public static enum STATE {
        IDLE,
        CHECK_FOR_FOOD,
        SEARCH_RESTAURANT,
        GO_TO_RESTAURANT,
        WAIT_FOR_FOOD,
        GET_FOOD_YOURSELF,
        FIND_PLACE_TO_EAT,
        EAT;

    }
}

