/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCombatAcademy;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.trainingcamps.AbstractEntityAITraining;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAICombatTraining
extends AbstractEntityAITraining<JobCombatTraining> {
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int DEXTERITY_MULTIPLIER = 1;
    private static final int ACTIONS_PER_BUILDING_LEVEL = 5;
    private static final double XP_BASE_RATE = 0.1;
    private static final int PARTNER_TRAINING_CHANCE = 25;
    private static final int TRAININGS_DELAY = 60;
    private static final int MIN_DISTANCE_TO_TRAIN = 5;
    private BlockPos currentCombatTarget;
    private EntityCitizen trainingPartner;
    private int targetCounter;

    public EntityAICombatTraining(@NotNull JobCombatTraining job) {
        super(job);
        super.registerTargets(new AITarget(AIState.COMBAT_TRAINING, true, this::decideOnTrainingType), new AITarget(AIState.FIND_TRAINING_PARTNER, true, this::findTrainingPartner), new AITarget(AIState.KNIGHT_TRAIN_WITH_PARTNER, true, this::trainWithPartner), new AITarget(AIState.FIND_DUMMY_PARTNER, true, this::findDummyPartner), new AITarget(AIState.KNIGHT_ATTACK_DUMMY, true, this::attackDummy), new AITarget(AIState.KNIGHT_ATTACK_PROTECT, true, this::attack));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getDexterity());
    }

    private AIState decideOnTrainingType() {
        this.setDelay(5);
        if (this.getOwnBuilding(BuildingCombatAcademy.class).hasCombatPartner(this.worker) || this.worker.getRandom().nextInt(100) < 25) {
            return AIState.FIND_TRAINING_PARTNER;
        }
        return AIState.FIND_DUMMY_PARTNER;
    }

    @Override
    public AIState decide() {
        if (this.getOwnBuilding(BuildingCombatAcademy.class).hasCombatPartner(this.worker)) {
            this.setDelay(5);
            return AIState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return super.decide();
    }

    private AIState findTrainingPartner() {
        this.setDelay(5);
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.getOwnBuilding();
        this.trainingPartner = academy.hasCombatPartner(this.worker) ? academy.getCombatPartner(this.worker) : academy.getRandomCombatPartner(this.worker);
        if (this.trainingPartner == null) {
            return AIState.COMBAT_TRAINING;
        }
        return AIState.KNIGHT_TRAIN_WITH_PARTNER;
    }

    private AIState trainWithPartner() {
        this.setDelay(5);
        if (this.trainingPartner == null) {
            return AIState.COMBAT_TRAINING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.trainingPartner.func_180425_c()) > 5L && this.walkToBlock(this.trainingPartner.func_180425_c())) {
            return AIState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return AIState.KNIGHT_ATTACK_PROTECT;
    }

    private AIState attack() {
        this.setDelay(5);
        if (this.trainingPartner == null) {
            return AIState.START_WORKING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.trainingPartner.func_180425_c()) > 5L) {
            this.currentPathingTarget = this.trainingPartner.func_180425_c();
            this.stateAfterPathing = AIState.KNIGHT_TRAIN_WITH_PARTNER;
            return AIState.GO_TO_TARGET;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(0.1);
            this.worker.decreaseSaturationForAction();
            this.worker.func_70625_a((Entity)this.trainingPartner, 180.0f, 180.0f);
            WorkerUtil.faceBlock(this.trainingPartner.func_180425_c().func_177984_a(), this.worker);
            this.worker.func_184602_cy();
            if (this.worker.getRandom().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), Items.field_185159_cQ, -1);
                if (shieldSlot != -1) {
                    this.worker.func_184185_a(SoundEvents.field_187767_eL, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                    this.worker.getCitizenItemHandler().setHeldItem(EnumHand.OFF_HAND, shieldSlot);
                    this.worker.func_184598_c(EnumHand.OFF_HAND);
                    this.worker.func_70671_ap().func_75651_a((Entity)this.trainingPartner, 180.0f, 180.0f);
                }
            } else {
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                this.trainingPartner.func_70097_a(new DamageSource(this.worker.func_70005_c_()), 0.0f);
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
            }
            this.worker.getNavigator().moveAwayFromXYZ(this.trainingPartner.func_180425_c(), 4.0, this.worker.func_70689_ay());
            ++this.targetCounter;
            if (this.targetCounter > ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() * 5) {
                this.getOwnBuilding(BuildingCombatAcademy.class).resetPartner(this.worker);
                this.targetCounter = 0;
                return AIState.START_WORKING;
            }
        } else {
            this.reduceAttackDelay();
            return AIState.KNIGHT_ATTACK_PROTECT;
        }
        this.currentAttackDelay = 20;
        this.setDelay(60);
        return AIState.KNIGHT_ATTACK_PROTECT;
    }

    private AIState findDummyPartner() {
        this.setDelay(5);
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.getOwnBuilding();
        if (this.targetCounter >= academy.getBuildingLevel() * 5) {
            this.worker.func_184602_cy();
            this.targetCounter = 0;
            return AIState.DECIDE;
        }
        if (this.getOwnBuilding(BuildingCombatAcademy.class).hasCombatPartner(this.worker)) {
            this.setDelay(5);
            return AIState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        BlockPos targetPos = academy.getRandomCombatTarget(this.worker.getRandom());
        if (targetPos == null) {
            this.worker.func_184602_cy();
            return AIState.DECIDE;
        }
        this.currentCombatTarget = targetPos;
        ++this.targetCounter;
        this.currentPathingTarget = targetPos;
        this.stateAfterPathing = AIState.KNIGHT_ATTACK_DUMMY;
        return AIState.GO_TO_TARGET;
    }

    private AIState attackDummy() {
        this.setDelay(5);
        if (this.currentCombatTarget == null) {
            return AIState.START_WORKING;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(0.1);
            this.worker.decreaseSaturationForAction();
            WorkerUtil.faceBlock(this.currentCombatTarget, this.worker);
            this.worker.func_184602_cy();
            if (this.worker.getRandom().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), Items.field_185159_cQ, -1);
                if (shieldSlot != -1) {
                    this.worker.func_184185_a(SoundEvents.field_187767_eL, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                    this.worker.getCitizenItemHandler().setHeldItem(EnumHand.OFF_HAND, shieldSlot);
                    this.worker.func_184598_c(EnumHand.OFF_HAND);
                }
            } else {
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            return AIState.KNIGHT_ATTACK_DUMMY;
        }
        this.currentAttackDelay = 20;
        this.setDelay(60);
        return AIState.FIND_DUMMY_PARTNER;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.SWORD)) {
            this.setDelay(60);
            return false;
        }
        if (this.checkForToolOrWeapon(ToolType.SHIELD)) {
            this.setDelay(60);
            return false;
        }
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, weaponSlot);
        }
        return true;
    }
}

