/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingArchery;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.entity.ai.citizen.guard.GuardArrow;
import com.minecolonies.coremod.entity.ai.citizen.trainingcamps.AbstractEntityAITraining;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIArcherTraining
extends AbstractEntityAITraining<JobArcherTraining> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int XP_PER_SUCCESSFUL_SHOT = 1;
    private static final int BUILDING_LEVEL_TARGET_MULTIPLIER = 5;
    private static final double MIN_DISTANCE_FOR_SUCCESS = 2.0;
    private static final int RANGED_ATTACK_DELAY_BASE = 10;
    private static final double XP_BASE_RATE = 0.1;
    private static final int CHECK_SHOT_DELAY = 60;
    private BlockPos currentShootingTarget;
    private int targetCounter;
    private EntityTippedArrow arrowInProgress;

    public EntityAIArcherTraining(@NotNull JobArcherTraining job) {
        super(job);
        super.registerTargets(new AITarget(AIState.COMBAT_TRAINING, true, this::findShootingStandPosition), new AITarget(AIState.ARCHER_SELECT_TARGET, true, this::selectTarget), new AITarget(AIState.ARCHER_CHECK_SHOT, true, this::checkShot), new AITarget(AIState.ARCHER_SHOOT, true, this::shoot));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
    }

    private AIState selectTarget() {
        this.setDelay(5);
        BuildingArchery archeryBuilding = (BuildingArchery)this.getOwnBuilding();
        if (this.targetCounter >= archeryBuilding.getBuildingLevel() * 5) {
            this.targetCounter = 0;
            return AIState.DECIDE;
        }
        BlockPos targetPos = archeryBuilding.getRandomShootingTarget(this.worker.getRandom());
        if (targetPos == null) {
            return AIState.DECIDE;
        }
        this.currentShootingTarget = targetPos;
        ++this.targetCounter;
        return AIState.ARCHER_SHOOT;
    }

    private AIState findShootingStandPosition() {
        this.setDelay(5);
        BuildingArchery archeryBuilding = (BuildingArchery)this.getOwnBuilding();
        BlockPos shootingPos = archeryBuilding.getRandomShootingStandPosition(this.worker.getRandom());
        if (shootingPos == null) {
            return AIState.DECIDE;
        }
        this.stateAfterPathing = AIState.ARCHER_SELECT_TARGET;
        this.currentPathingTarget = shootingPos;
        return AIState.GO_TO_TARGET;
    }

    protected AIState shoot() {
        GuardArrow arrow;
        this.setDelay(5);
        if (this.currentShootingTarget == null) {
            return AIState.START_WORKING;
        }
        if (this.worker.func_184587_cr()) {
            WorkerUtil.faceBlock(this.currentShootingTarget, this.worker);
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            arrow = new GuardArrow(this.world, this.worker);
            double xVector = (double)this.currentShootingTarget.func_177958_n() - this.worker.field_70165_t;
            double yVector = (double)this.currentShootingTarget.func_177956_o() - arrow.field_70163_u;
            double zVector = (double)this.currentShootingTarget.func_177952_p() - this.worker.field_70161_v;
            double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
            double chance = 15.0 / (double)(this.worker.getCitizenData().getLevel() + 1);
            arrow.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
            this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            this.worker.field_70170_p.func_72838_d((Entity)arrow);
            double xDiff = (double)this.currentShootingTarget.func_177958_n() - this.worker.field_70165_t;
            double zDiff = (double)this.currentShootingTarget.func_177952_p() - this.worker.field_70161_v;
            double goToX = xDiff > 0.0 ? 0.01 : -0.01;
            double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
            this.worker.func_70091_d(MoverType.SELF, goToX, 0.0, goToZ);
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            if (this.currentAttackDelay <= 0) {
                this.worker.func_184598_c(EnumHand.MAIN_HAND);
            }
            return AIState.ARCHER_SHOOT;
        }
        this.worker.func_184602_cy();
        this.incrementActionsDoneAndDecSaturation();
        this.arrowInProgress = arrow;
        this.currentAttackDelay = 10;
        this.setDelay(60);
        return AIState.ARCHER_CHECK_SHOT;
    }

    private AIState checkShot() {
        if (this.arrowInProgress.func_174818_b(this.currentShootingTarget) < 2.0) {
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        } else {
            this.worker.getCitizenExperienceHandler().addExperience(0.1);
        }
        return AIState.ARCHER_SELECT_TARGET;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.BOW)) {
            this.setDelay(60);
            return false;
        }
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.BOW, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
        this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, bowSlot);
        return true;
    }
}

