/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindTree;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkLumberjack
extends AbstractEntityAIInteract<JobLumberjack> {
    private static final String RENDER_META_LOGS = "Logs";
    private static final int SEARCH_RANGE = 50;
    private static final int SEARCH_INCREMENT = 5;
    private static final int SEARCH_LIMIT = 150;
    public static final float RANGE_VERTICAL_PICKUP = 2.0f;
    public static final float RANGE_HORIZONTAL_PICKUP = 5.0f;
    private static final int STUCK_WAIT_TIME = 10;
    private static final int WALKING_BACK_WAIT_TIME = 60;
    private static final double WALK_BACK_RANGE = 3.0;
    private static final double WALK_BACK_SPEED = 1.0;
    private static final int STANDARD_WORKING_RANGE = 1;
    private static final int MIN_WORKING_RANGE = 1;
    private static final int WAIT_BEFORE_SAPLING = 50;
    private static final int MAX_WAITING_TIME = 50;
    private static final int TIMEOUT_DELAY = 10;
    private static final int LEAVES_RADIUS = 3;
    private static final int WAIT_BEFORE_SEARCH = 100;
    private static final int WAIT_BEFORE_INCREMENT = 20;
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int CHARISMA_MULTIPLIER = 1;
    private static final int MAX_BLOCKS_MINED = 32;
    private BlockPos workFrom;
    private int timeWaited = 0;
    private int stillTicks = 0;
    private int previousDistance = 0;
    private boolean checkedInHut = false;
    @Nullable
    private PathJobFindTree.TreePathResult pathResult;
    private int searchIncrement = 0;

    public EntityAIWorkLumberjack(@NotNull JobLumberjack job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING, true), new AITarget(AIState.START_WORKING, true, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, true, this::prepareForWoodcutting), new AITarget(AIState.LUMBERJACK_SEARCHING_TREE, true, this::findTrees), new AITarget(AIState.LUMBERJACK_CHOP_TREE, false, this::chopWood), new AITarget(AIState.LUMBERJACK_GATHERING, true, this::gathering), new AITarget(AIState.LUMBERJACK_NO_TREES_FOUND, true, this::waitBeforeCheckingAgain));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingLumberjack.class;
    }

    private boolean isStackLog(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d().isWood((IBlockAccess)this.world, new BlockPos(0, 0, 0));
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    private AIState prepareForWoodcutting() {
        if (this.checkForToolOrWeapon(ToolType.AXE)) {
            return this.getState();
        }
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    private AIState waitBeforeCheckingAgain() {
        if (this.hasNotDelayed(100)) {
            return this.getState();
        }
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    private AIState findTrees() {
        if (((JobLumberjack)this.job).tree == null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.searchingtree", new Object[0])});
            return this.findTree();
        }
        return AIState.LUMBERJACK_CHOP_TREE;
    }

    private AIState findTree() {
        Object building = this.getOwnBuilding();
        if (this.pathResult != null && this.pathResult.isInProgress()) {
            return this.getState();
        }
        if (this.pathResult == null || this.pathResult.treeLocation == null) {
            this.pathResult = this.worker.getNavigator().moveToTree(50 + this.searchIncrement, 1.0, ((BuildingLumberjack)building).getTreesToNotCut(), this.worker.getCitizenColonyHandler().getColony());
            this.setDelay(100);
            return this.getState();
        }
        if (this.pathResult.isPathReachingDestination()) {
            return this.setNewTree();
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIState.LUMBERJACK_GATHERING;
        }
        return this.getState();
    }

    private AIState setNewTree() {
        if (this.pathResult.treeLocation == null) {
            this.setDelay(20);
            if (this.searchIncrement + 50 > 150) {
                return AIState.LUMBERJACK_NO_TREES_FOUND;
            }
            this.searchIncrement += 5;
        } else {
            ((JobLumberjack)this.job).tree = new Tree(this.world, this.pathResult.treeLocation);
            if (((JobLumberjack)this.job).tree.isTree()) {
                ((JobLumberjack)this.job).tree.findLogs(this.world);
            } else {
                ((JobLumberjack)this.job).tree = null;
            }
        }
        this.pathResult = null;
        return this.getState();
    }

    private AIState chopWood() {
        if (this.checkForToolOrWeapon(ToolType.AXE)) {
            return AIState.IDLE;
        }
        if (((JobLumberjack)this.job).tree == null) {
            return AIState.LUMBERJACK_SEARCHING_TREE;
        }
        return this.chopTree();
    }

    private AIState chopTree() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.chopping", new Object[0])});
        if (((JobLumberjack)this.job).tree.hasLogs() || this.checkedInHut) {
            BlockPos location = ((JobLumberjack)this.job).tree.getLocation();
            if (!this.walkToTree(((JobLumberjack)this.job).tree.getStumpLocations().get(0))) {
                this.checkIfStuckOnLeaves(location);
                return this.getState();
            }
        }
        if (!(((JobLumberjack)this.job).tree.hasLogs() || ((JobLumberjack)this.job).tree.isSlimeTree() && ((JobLumberjack)this.job).tree.hasLeaves())) {
            if (this.hasNotDelayed(50)) {
                return this.getState();
            }
            BuildingLumberjack building = this.getOwnBuilding(BuildingLumberjack.class);
            if (building.shouldReplant()) {
                this.plantSapling();
            } else {
                ((JobLumberjack)this.job).tree = null;
                this.checkedInHut = false;
            }
            this.incrementActionsDoneAndDecSaturation();
            building.getColony().getStatsManager().incrementStatistic("trees");
            this.workFrom = null;
            return AIState.LUMBERJACK_GATHERING;
        }
        if (this.isOnSapling()) {
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(this.world, this.workFrom, 1, 1, 1, 3, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N});
            WorkerUtil.setSpawnPoint(spawnPoint, this.worker);
        }
        if (((JobLumberjack)this.job).tree.hasLogs()) {
            BlockPos log = ((JobLumberjack)this.job).tree.peekNextLog();
            if (((JobLumberjack)this.job).tree.isDynamicTree()) {
                if (!this.mineBlock(log, this.workFrom, false, false, Compatibility.getDynamicTreeBreakAction(this.world, log, this.worker.func_184586_b(EnumHand.MAIN_HAND), this.worker.func_180425_c()))) {
                    return this.getState();
                }
                for (int i = 0; i < 6; ++i) {
                    this.incrementActionsDone();
                }
                this.setDelay(100);
            } else if (!this.mineBlock(log, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).tree.pollNextLog();
            this.worker.decreaseSaturationForContinuousAction();
        } else if (((JobLumberjack)this.job).tree.hasLeaves() && ((JobLumberjack)this.job).tree.isSlimeTree()) {
            BlockPos leaf = ((JobLumberjack)this.job).tree.peekNextLeaf();
            if (!this.mineBlock(leaf, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).tree.pollNextLeaf();
        }
        return this.getState();
    }

    public boolean walkToTree(BlockPos workAt) {
        if (this.workFrom == null || this.world.func_180495_p(this.workFrom.func_177984_a()).func_177230_c() == Blocks.field_150345_g || this.world.func_180495_p(this.workFrom).func_177230_c() == Blocks.field_150345_g) {
            this.workFrom = this.getWorkingPosition(workAt);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 1) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) <= 1.0;
    }

    private void checkIfStuckOnLeaves(@NotNull BlockPos location) {
        int distance = (int)location.func_177951_i((Vec3i)this.worker.func_180425_c());
        if (this.previousDistance != distance) {
            this.stillTicks = 0;
            this.previousDistance = distance;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks < 10) {
            return;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.stuckinleaves", new Object[0])});
        this.tryGettingUnstuckFromLeaves();
    }

    private void plantSapling() {
        if (this.plantSapling(((JobLumberjack)this.job).tree.getLocation())) {
            ((JobLumberjack)this.job).tree = null;
            this.checkedInHut = false;
        }
    }

    private boolean isOnSapling() {
        return this.world.func_180495_p(this.worker.func_180425_c()).func_177230_c() == Blocks.field_150345_g || this.world.func_180495_p(this.worker.func_180425_c().func_177984_a()).func_177230_c() == Blocks.field_150345_g || this.world.func_180495_p(this.worker.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150345_g;
    }

    private void tryGettingUnstuckFromLeaves() {
        BlockPos nextLeaves = this.findNearLeaves();
        if (nextLeaves == null || this.stillTicks > 60) {
            this.worker.getNavigator().moveAwayFromXYZ(this.worker.func_180425_c(), 3.0, 1.0);
            this.stillTicks = 0;
            return;
        }
        if (!this.mineBlock(nextLeaves, this.workFrom)) {
            return;
        }
        this.stillTicks = 0;
    }

    private boolean plantSapling(@NotNull BlockPos location) {
        Block worldBlock = this.world.func_180495_p(location).func_177230_c();
        if (worldBlock != Blocks.field_150350_a && !(worldBlock instanceof BlockSapling)) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.planting", new Object[0])});
        int saplingSlot = this.findSaplingSlot();
        BlockPos dirtLocation = new BlockPos(location.func_177958_n(), location.func_177956_o() - 1, location.func_177952_p());
        Block dirt = this.world.func_180495_p(dirtLocation).func_177230_c();
        if (saplingSlot != -1 && (((JobLumberjack)this.job).tree.isSlimeTree() && Compatibility.isSlimeDirtOrGrass(dirt) || !((JobLumberjack)this.job).tree.isSlimeTree() && !Compatibility.isSlimeDirtOrGrass(dirt))) {
            ItemStack stack = this.getInventory().func_70301_a(saplingSlot);
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, saplingSlot);
            if (((JobLumberjack)this.job).tree.isDynamicTree() && Compatibility.isDynamicTreeSapling(stack)) {
                Compatibility.plantDynamicSapling(this.world, location, stack);
                new InvWrapper((IInventory)this.getInventory()).extractItem(saplingSlot, 1, false);
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.timeWaited = 0;
                this.incrementActionsDoneAndDecSaturation();
                this.setDelay(10);
                return true;
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            this.placeSaplings(saplingSlot, stack, block);
            SoundType soundType = block.getSoundType(this.world.func_180495_p(location), this.world, location, (Entity)this.worker);
            this.world.func_184133_a(null, this.worker.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
            this.worker.func_184609_a(this.worker.func_184600_cs());
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("saplings");
        }
        if (this.timeWaited >= 25 && !this.checkedInHut && !this.walkToBuilding()) {
            this.isInHut(((JobLumberjack)this.job).tree.getSapling());
            this.checkedInHut = true;
        }
        if (((JobLumberjack)this.job).tree.getStumpLocations().isEmpty() || this.timeWaited >= 50) {
            this.timeWaited = 0;
            this.incrementActionsDoneAndDecSaturation();
            this.setDelay(10);
            return true;
        }
        this.timeWaited += 10;
        return false;
    }

    @Override
    public void fillItemsList() {
        if (((JobLumberjack)this.job).tree != null) {
            this.searchForItems(new AxisAlignedBB(((JobLumberjack)this.job).tree.getLocation()).func_72321_a(5.0, 2.0, 5.0).func_72321_a(-5.0, -2.0, -5.0));
        } else {
            this.searchForItems(this.worker.func_174813_aQ().func_72321_a(5.0, 2.0, 5.0).func_72321_a(-5.0, -2.0, -5.0));
        }
    }

    private BlockPos findNearLeaves() {
        int playerX = this.worker.func_180425_c().func_177958_n();
        int playerY = this.worker.func_180425_c().func_177956_o() + 1;
        int playerZ = this.worker.func_180425_c().func_177952_p();
        int radius = 3;
        for (int x = playerX - 3; x < playerX + 3; ++x) {
            for (int y = playerY - 3; y < playerY + 3; ++y) {
                for (int z = playerZ - 3; z < playerZ + 3; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.world.func_180495_p(pos).func_177230_c().isLeaves(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private int findSaplingSlot() {
        for (int slot = 0; slot < new InvWrapper((IInventory)this.getInventory()).getSlots(); ++slot) {
            ItemStack stack = this.getInventory().func_70301_a(slot);
            if (!this.isCorrectSapling(stack)) continue;
            return slot;
        }
        return -1;
    }

    private void placeSaplings(int saplingSlot, @NotNull ItemStack stack, @NotNull Block block) {
        while (!((JobLumberjack)this.job).tree.getStumpLocations().isEmpty()) {
            BlockPos pos = ((JobLumberjack)this.job).tree.getStumpLocations().get(0);
            if (BlockPosUtil.setBlock(this.world, pos, block.func_176203_a(stack.func_77960_j()), 2) && this.getInventory().func_70301_a(saplingSlot) != null || Objects.equals(this.world.func_180495_p(pos), block.func_176203_a(stack.func_77960_j()))) {
                new InvWrapper((IInventory)this.getInventory()).extractItem(saplingSlot, 1, false);
                ((JobLumberjack)this.job).tree.removeStump(pos);
                continue;
            }
            return;
        }
    }

    private boolean isCorrectSapling(ItemStack stack) {
        if (!ItemStackUtils.isStackSapling(stack)) {
            return false;
        }
        if (ItemStackUtils.isEmpty(((JobLumberjack)this.job).tree.getSapling()).booleanValue()) {
            return true;
        }
        return ((JobLumberjack)this.job).tree.getSapling().func_77969_a(stack);
    }

    private AIState gathering() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.hasLogs() ? RENDER_META_LOGS : "");
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getWorkingPosition(2, targetPosition, 0);
    }

    private boolean hasLogs() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.getInventory()), this::isStackLog);
    }
}

