/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, EntityCow> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getDexterity() + this.worker.getCitizenData().getStrength());
        super.registerTargets(new AITarget(AIState.COWBOY_MILK, false, this::milkCows));
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingCowboy.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        return new ItemStack(Items.field_151015_O);
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<EntityCow> getAnimalClass() {
        return EntityCow.class;
    }

    @Override
    public AIState decideWhatToDo() {
        AIState result = super.decideWhatToDo();
        BuildingCowboy building = (BuildingCowboy)this.getOwnBuilding();
        boolean hasBucket = InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), Items.field_151133_ar, 0);
        if (building != null && building.isMilkingCows() && result.equals((Object)AIState.START_WORKING) && hasBucket) {
            return AIState.COWBOY_MILK;
        }
        return result;
    }

    @Override
    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        List<ItemStack> list = super.getExtraItemsNeeded();
        if (this.getOwnBuilding(BuildingCowboy.class).isMilkingCows()) {
            list.add(new ItemStack(Items.field_151133_ar));
        }
        return list;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return this.getExtraItemsNeeded();
    }

    private AIState milkCows() {
        EntityCow cow;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.cowboy.milking", new Object[0])});
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getBreedingItem().func_77973_b(), 0) && this.isInHut(new ItemStack(Items.field_151133_ar, 1))) {
            if (!this.walkToBuilding() && this.getOwnBuilding() != null) {
                this.isInTileEntity((TileEntity)((AbstractBuildingContainer)this.getOwnBuilding()).getTileEntity(), new ItemStack(Items.field_151133_ar, 1));
            } else {
                return AIState.DECIDE;
            }
        }
        if ((cow = (EntityCow)this.searchForAnimals().stream().findFirst().orElse(null)) == null) {
            return AIState.DECIDE;
        }
        if (!this.walkingToAnimal((EntityAnimal)cow) && this.equipItem(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar, 1))) {
            if (!this.worker.getInventoryCitizen().addItemStackToInventory(new ItemStack(Items.field_151117_aB))) {
                this.worker.getCitizenItemHandler().removeHeldItem();
                this.equipItem(EnumHand.MAIN_HAND, new ItemStack(Items.field_151117_aB));
                InventoryUtils.removeStackFromItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), new ItemStack(Items.field_151133_ar, 1));
            }
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
        return AIState.DECIDE;
    }
}

