/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIKnight
extends AbstractEntityAIGuard<JobKnight> {
    public EntityAIKnight(@NotNull JobKnight job) {
        super(job);
        super.registerTargets(new AITarget(AIState.GUARD_ATTACK_PROTECT, false, this::attackProtect), new AITarget(AIState.GUARD_ATTACK_PHYSICAL, false, this::attackPhysical));
        this.toolsNeeded.add(ToolType.SWORD);
        for (List list : this.itemsNeeded) {
            list.add(new GuardGear(ToolType.SHIELD, EntityEquipmentSlot.MAINHAND, 0, 0, GuardConstants.SHIELD_LEVEL_RANGE, GuardConstants.SHIELD_BUILDING_LEVEL_RANGE));
        }
    }

    @Override
    public AIState getAttackState() {
        return AIState.GUARD_ATTACK_PHYSICAL;
    }

    @Override
    protected int getAttackRange() {
        return 3;
    }

    @Override
    public boolean hasMainWeapon() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel()) != -1;
    }

    @Override
    public void wearWeapon() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, weaponSlot);
        }
    }

    @Override
    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            int reload = 50 - this.worker.getCitizenData().getLevel();
            return reload > 10 ? reload : 10;
        }
        return 50;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(new ItemStack(Items.field_185159_cQ, 1));
        return list;
    }

    protected AIState attackProtect() {
        this.setDelay(2);
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), Items.field_185159_cQ, -1);
        if (shieldSlot != -1 && this.target != null && !this.target.field_70128_L) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.OFF_HAND, shieldSlot);
            this.worker.func_184598_c(EnumHand.OFF_HAND);
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIState.GUARD_ATTACK_PHYSICAL;
    }

    protected AIState attackPhysical() {
        AIState state = this.preAttackChecks();
        if (state != this.getState()) {
            this.setDelay(5);
            return state;
        }
        if (this.currentAttackDelay > 0) {
            this.reduceAttackDelay(4);
            return AIState.GUARD_ATTACK_PROTECT;
        }
        this.currentAttackDelay = this.getAttackDelay();
        if (this.getOwnBuilding() != null) {
            int fireLevel;
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            double damageToBeDealt = this.getAttackDamage();
            if ((double)this.worker.func_110143_aJ() <= (double)this.worker.func_110138_aP() * 0.2) {
                damageToBeDealt *= 2.0;
            }
            DamageSource source = new DamageSource(this.worker.func_70005_c_());
            if (Configurations.gameplay.pvp_mode && this.target instanceof EntityPlayer) {
                source.func_76348_h();
            }
            if ((fireLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.worker.func_184586_b(EnumHand.MAIN_HAND))) > 0) {
                this.target.func_70015_d(fireLevel * 80);
            }
            this.target.func_70097_a(source, (float)damageToBeDealt);
            this.target.func_70604_c((EntityLivingBase)this.worker);
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
        }
        return AIState.GUARD_ATTACK_PHYSICAL;
    }

    private int getAttackDamage() {
        if (this.worker.getCitizenData() != null) {
            int addDmg = 0;
            ItemStack heldItem = this.worker.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
                addDmg = heldItem.func_77973_b() instanceof ItemSword ? (int)((float)addDmg + ((ItemSword)heldItem.func_77973_b()).func_150931_i()) : (int)((double)addDmg + TinkersWeaponHelper.getDamage(heldItem));
                addDmg = (int)((double)addDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (EnumCreatureAttribute)this.target.func_70668_bt()) / 2.5);
            }
            return (int)((double)(3 + (addDmg += this.getLevelDamage())) * Configurations.gameplay.rangerDamageMult);
        }
        return (int)(3.0 * Configurations.gameplay.knightDamageMult);
    }
}

