/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.cook;

import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAIUsesFurnace<JobCook> {
    private static final int CHARISMA_MULTIPLIER = 2;
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    public static final int AMOUNT_OF_FOOD_TO_SERVE = 2;
    private static final int SERVE_DELAY = 30;
    private static final int LEVEL_TO_FEED_PLAYER = 10;
    private final List<EntityCitizen> citizenToServe = new ArrayList<EntityCitizen>();
    private final List<EntityPlayer> playerToServe = new ArrayList<EntityPlayer>();
    private AxisAlignedBB range = null;

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget(AIState.COOK_SERVE_FOOD_TO_CITIZEN, true, this::serveFoodToCitizen));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getCharisma() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    @Override
    protected void extractFromFurnace(TileEntityFurnace furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)furnace), 2, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        return ItemStackUtils.ISCOOKABLE.test(stack);
    }

    @Override
    protected boolean reachedMaxToKeep() {
        return InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), ItemStackUtils.ISFOOD) > Math.max(1, ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() * ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel()) * 9;
    }

    private AIState serveFoodToCitizen() {
        InvWrapper handler;
        Entity living;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.serving", new Object[0])});
        if (this.citizenToServe.isEmpty() && this.playerToServe.isEmpty()) {
            return AIState.START_WORKING;
        }
        Entity entity = living = this.citizenToServe.isEmpty() ? (Entity)this.playerToServe.get(0) : (Entity)this.citizenToServe.get(0);
        if (this.range == null) {
            this.range = ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        if (!this.range.func_186667_c(new Vec3d((Vec3i)living.func_180425_c())) || this.worker.getCitizenStuckHandler().isStuck()) {
            this.worker.getNavigator().func_75499_g();
            this.removeFromQueue();
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(living.func_180425_c())) {
            this.setDelay(2);
            return this.getState();
        }
        InvWrapper invWrapper = handler = this.citizenToServe.isEmpty() ? new InvWrapper((IInventory)this.playerToServe.get((int)0).field_71071_by) : new InvWrapper((IInventory)this.citizenToServe.get(0).getInventoryCitizen());
        if (InventoryUtils.isItemHandlerFull((IItemHandler)handler)) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.cook.full", new Object[0]);
            this.removeFromQueue();
            this.setDelay(30);
            return this.getState();
        }
        InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD, ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() * 2, (IItemHandler)handler);
        if (this.citizenToServe.isEmpty() && living instanceof EntityPlayer) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)living, "com.minecolonies.coremod.cook.serve.player", this.worker.func_70005_c_());
        }
        this.removeFromQueue();
        this.setDelay(30);
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIState.START_WORKING;
    }

    private void removeFromQueue() {
        if (this.citizenToServe.isEmpty()) {
            this.playerToServe.remove(0);
        } else {
            this.citizenToServe.remove(0);
        }
    }

    @Override
    protected AIState checkForImportantJobs() {
        if (this.range == null) {
            this.range = ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        this.citizenToServe.clear();
        List citizenList = this.world.func_175647_a(EntityCitizen.class, this.range, cit -> !(cit.getCitizenJobHandler().getColonyJob() instanceof JobCook) && cit.getCitizenData() != null && cit.getCitizenData().getSaturation() <= 5.0);
        List playerList = this.world.func_175647_a(EntityPlayer.class, this.range, player -> player != null && player.func_71024_bL().func_75116_a() < 10);
        if (!citizenList.isEmpty() || !playerList.isEmpty()) {
            this.citizenToServe.addAll(citizenList);
            this.playerToServe.addAll(playerList);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD)) {
                return AIState.COOK_SERVE_FOOD_TO_CITIZEN;
            }
            this.needsCurrently = ItemStackUtils.ISFOOD;
            return AIState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIState.START_WORKING;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new Food(64);
    }
}

