/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int DEPTH_LEVEL_0 = 60;
    private static final int DEPTH_LEVEL_1 = 30;
    private static final int MAX_DEPTH_DIFFERENCE = 5;
    private static final int DEPTH_LEVEL_2 = 15;
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int SPEED_BUFF_1 = 2;
    private static final int SPEED_BUFF_2 = 4;
    private static final int ACTIONS_UNTIL_DUMP = 1024;
    private static final int MIN_DISTANCE = 3;
    private static final int MAX_DISTANCE = 5;
    private static final double ACCEPTANCE_DISTANCE = 12.0;
    private int pickUpCount = 0;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING, true), new AITarget(this::checkIfExecute, true, this::getState), new AITarget(AIState.START_WORKING, true, this::startWorkingAtOwnBuilding), new AITarget(AIState.PICK_UP, false, this::pickUpMaterial));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    @Override
    public AIState getStateAfterPickUp() {
        return AIState.PICK_UP;
    }

    public AIState pickUpMaterial() {
        BuildingBuilder building = (BuildingBuilder)this.getOwnBuilding();
        ArrayList<Predicate<ItemStack>> neededItemsList = new ArrayList<Predicate<ItemStack>>(building.getRequiredItemsAndAmount().keySet());
        if (neededItemsList.size() <= this.pickUpCount || InventoryUtils.openSlotCount((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen())) <= 5L) {
            this.pickUpCount = 0;
            return AIState.START_WORKING;
        }
        this.needsCurrently = (Predicate)neededItemsList.get(this.pickUpCount);
        ++this.pickUpCount;
        return AIState.GATHERING_REQUIRED_MATERIALS;
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkIfExecute() {
        this.setDelay(1);
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).searchWorkOrder();
            return true;
        }
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            return true;
        }
        AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
        if (building == null && wo instanceof WorkOrderBuild && !(wo instanceof WorkOrderBuildRemoval)) {
            ((JobBuilder)this.job).complete();
            return true;
        }
        if (!((JobBuilder)this.job).hasStructure()) {
            super.initiate();
        }
        return false;
    }

    @Override
    public AIState switchStage(AIState state) {
        if (((JobBuilder)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval && state.equals((Object)AIState.BUILDING_STEP)) {
            return AIState.COMPLETE_BUILD;
        }
        return super.switchStage(state);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.START_BUILDING;
    }

    @Override
    public AIState afterRequestPickUp() {
        return AIState.INVENTORY_FULL;
    }

    @Override
    public AIState afterDump() {
        return AIState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos targetPos) {
        if (this.workFrom == null || MathUtils.twoDimDistance(targetPos, this.workFrom) < 3.0 || MathUtils.twoDimDistance(targetPos, this.workFrom) > 12.0) {
            this.workFrom = this.getWorkingPosition(targetPos);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) <= 12.0;
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        if (((JobBuilder)this.job).getWorkOrder() != null) {
            BlockPos schemPos = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
            int yStart = targetPosition.func_177956_o() > schemPos.func_177956_o() ? targetPosition.func_177956_o() : schemPos.func_177956_o();
            int yEnd = targetPosition.func_177956_o() < schemPos.func_177956_o() ? Math.max(targetPosition.func_177956_o(), schemPos.func_177956_o() - 5) : schemPos.func_177956_o();
            EnumFacing direction = BlockPosUtil.getXZFacing(this.worker.func_180425_c(), targetPosition).func_176734_d();
            for (int i = 4; i < 5; ++i) {
                for (int y = yStart; y >= yEnd; --y) {
                    BlockPos pos = targetPosition.func_177967_a(direction, i);
                    BlockPos basePos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                    if (!EntityUtils.checkForFreeSpace(this.world, basePos)) continue;
                    return basePos;
                }
            }
            return schemPos.func_177984_a();
        }
        return targetPosition;
    }

    @Override
    public void connectBlockToBuildingIfNecessary(@NotNull IBlockState blockState, @NotNull BlockPos pos) {
        BlockPos buildingLocation = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
        AbstractBuilding building = ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getBuildingManager().getBuilding(buildingLocation);
        if (building != null) {
            building.registerBlockPosition(blockState, pos, this.world);
        }
        if (blockState.func_177230_c() == ModBlocks.blockWayPoint) {
            this.worker.getCitizenColonyHandler().getColony().addWayPoint(pos, this.world.func_180495_p(pos));
        }
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, IBlockState worldMetadata) {
        return false;
    }

    @Override
    public IBlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.world, location);
    }

    @Override
    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        int initialDelay = super.getBlockMiningDelay(block, pos);
        if (pos.func_177956_o() > 60) {
            return (int)((double)initialDelay * 0.5);
        }
        if (pos.func_177956_o() > 30) {
            return initialDelay;
        }
        if (pos.func_177956_o() < 15) {
            return initialDelay * 4;
        }
        return initialDelay * 2;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }
}

