/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.Structure;
import com.structurize.coremod.blocks.schematic.BlockSolidSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure>
extends AbstractEntityAIStructure<J> {
    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingStructureBuilder.class;
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, Structure.Stage stage) {
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).setProgressPos(blockPos, stage);
    }

    @Override
    public Tuple<BlockPos, Structure.Stage> getProgressPos() {
        return this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getProgress();
    }

    public void initiate() {
        if (!((AbstractJobStructure)this.job).hasStructure()) {
            this.loadStructure();
            WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
                return;
            }
            if (wo instanceof WorkOrderBuildBuilding) {
                AbstractBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                    return;
                }
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildStart", ((AbstractJobStructure)this.job).getStructure().getName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderBuildMiner)) {
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildStart", wo.getName());
            }
        }
    }

    private void loadStructure() {
        WorkOrderBuildDecoration workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (workOrder instanceof WorkOrderBuildBuilding && this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation(this.world);
        boolean removal = workOrder instanceof WorkOrderBuildRemoval;
        super.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored(), removal);
        workOrder.setCleared(false);
        workOrder.setRequested(false);
        this.requestMaterials();
        if (this.getProgressPos() != null) {
            ((AbstractJobStructure)this.job).getStructure().setLocalPosition((BlockPos)this.getProgressPos().func_76341_a());
        }
    }

    private void requestMaterials() {
        if (Configurations.gameplay.builderInfiniteResources || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval) {
            return;
        }
        AbstractBuildingStructureBuilder buildingWorker = this.getOwnBuilding(AbstractBuildingStructureBuilder.class);
        buildingWorker.resetNeededResources();
        while (((AbstractJobStructure)this.job).getStructure().findNextBlock()) {
            IBlockState downState;
            Template.BlockInfo blockInfo = ((AbstractJobStructure)this.job).getStructure().getBlockInfo();
            Template.EntityInfo entityInfo = ((AbstractJobStructure)this.job).getStructure().getEntityinfo();
            if (entityInfo != null) {
                for (ItemStack stack : ItemStackUtils.getListOfStackForEntityInfo(entityInfo, this.world, (Entity)this.worker)) {
                    if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                    buildingWorker.addNeededResource(stack, 1);
                }
            }
            if (blockInfo == null) continue;
            IBlockState blockState = blockInfo.field_186243_b;
            Block block = blockState.func_177230_c();
            if (((AbstractJobStructure)this.job).getStructure().isStructureBlockEqualWorldBlock() || blockState.func_177230_c() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.func_177230_c() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) continue;
            if (block instanceof BlockSolidSubstitution) {
                blockState = this.getSolidSubstitution(((AbstractJobStructure)this.job).getStructure().getBlockPosition());
                block = blockState.func_177230_c();
            }
            Block worldBlock = BlockPosUtil.getBlock(this.world, ((AbstractJobStructure)this.job).getStructure().getBlockPosition());
            if (block instanceof BlockFalling && !(downState = BlockPosUtil.getBlockState(this.world, ((AbstractJobStructure)this.job).getStructure().getBlockPosition().func_177977_b())).func_185904_a().func_76220_a()) {
                this.requestBlockToBuildingIfRequired(buildingWorker, this.getSolidSubstitution(((AbstractJobStructure)this.job).getStructure().getBlockPosition()));
            }
            if (block == null || block == Blocks.field_150350_a || worldBlock == Blocks.field_150357_h || worldBlock instanceof AbstractBlockHut || AbstractEntityAIStructureWithWorkOrder.isBlockFree(block, 0)) continue;
            this.requestBlockToBuildingIfRequired(buildingWorker, blockState);
        }
        ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
    }

    private void requestBlockToBuildingIfRequired(AbstractBuildingStructureBuilder building, IBlockState blockState) {
        if (((AbstractJobStructure)this.job).getStructure().getBlockInfo().field_186244_c != null) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.addAll(this.getItemsFromTileEntity());
            for (ItemStack stack : itemList) {
                building.addNeededResource(stack, 1);
            }
        }
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(blockState) && blockState.func_177230_c() != Blocks.field_150324_C && blockState.func_177230_c() != Blocks.field_180393_cK && blockState.func_177230_c() != Blocks.field_180394_cL) {
            building.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
        }
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode;
        int n = hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        if (this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getNeededResources().get(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode) == null) {
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack).booleanValue()) {
            return 0;
        }
        int hashCode = deliveredItemStack.func_77942_o() ? deliveredItemStack.func_77978_p().hashCode() : 0;
        BuildingBuilderResource resource = this.getOwnBuilding(AbstractBuildingStructureBuilder.class).getNeededResources().get(deliveredItemStack.func_77977_a() + ":" + deliveredItemStack.func_77952_i() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((AbstractJobStructure)this.job).getStructure() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getStructure() == null) {
            return;
        }
        String structureName = ((AbstractJobStructure)this.job).getStructure().getName();
        WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo instanceof WorkOrderBuildBuilding) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageBuildComplete", structureName);
        }
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            WorkOrderBuildBuilding woh;
            WorkOrderBuildBuilding workOrderBuildBuilding = woh = wo instanceof WorkOrderBuildBuilding ? (WorkOrderBuildBuilding)wo : null;
            if (woh != null) {
                AbstractBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), woh.getBuildingLocation()));
                } else {
                    building.setBuildingLevel(woh.getUpgradeLevel());
                }
            }
            ((AbstractJobStructure)this.job).complete();
        }
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).resetNeededResources();
        this.func_75251_c();
    }

    @Override
    public List<ItemStack> getItemsFromTileEntity() {
        if (((AbstractJobStructure)this.job).getStructure() != null && ((AbstractJobStructure)this.job).getStructure().getBlockInfo() != null && ((AbstractJobStructure)this.job).getStructure().getBlockInfo().field_186244_c != null) {
            return ItemStackUtils.getItemStacksOfTileEntity(((AbstractJobStructure)this.job).getStructure().getBlockInfo().field_186244_c, this.world);
        }
        return Collections.emptyList();
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        this.getOwnBuilding(AbstractBuildingStructureBuilder.class).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && ((AbstractJobStructure)this.job).getStructure() != null) {
            super.func_75251_c();
            ((AbstractJobStructure)this.job).setStructure(null);
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).setProgressPos(null, Structure.Stage.CLEAR);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    protected void onStartWithoutStructure() {
        if (((AbstractJobStructure)this.job).getWorkOrder() != null) {
            this.loadStructure();
        }
    }

    @Override
    public Template.EntityInfo getEntityInfo() {
        if (((AbstractJobStructure)this.job).getStructure() != null && ((AbstractJobStructure)this.job).getStructure().getEntityinfo() != null) {
            return ((AbstractJobStructure)this.job).getStructure().getEntityinfo();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        AbstractBuildingStructureBuilder buildingWorker = this.getOwnBuilding(AbstractBuildingStructureBuilder.class);
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = new ItemStack(resource.getItem(), Math.min(64, resource.getAmount()), resource.getDamageValue());
        resStack.func_77982_d(resource.getItemStack().func_77978_p());
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }
}

