/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIInteract<J extends AbstractJob>
extends AbstractEntityAICrafting<J> {
    public static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int MIN_WORKING_RANGE = 12;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int STUCK_WAIT_TICKS = 20;
    private static final int WAIT_WHILE_WALKING = 5;
    public static final float RANGE_HORIZONTAL_PICKUP = 45.0f;
    public static final float RANGE_VERTICAL_PICKUP = 3.0f;
    private int stillTicks = 0;
    private int previousIndex = 0;
    @Nullable
    private List<BlockPos> items;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, new BlockPos((int)this.worker.field_70165_t, (int)this.worker.field_70163_u, (int)this.worker.field_70161_v));
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, true, null);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand, @NotNull boolean damageTool, @NotNull boolean getDrops, Runnable blockBreakAction) {
        IBlockState curBlockState = this.world.func_180495_p(blockToMine);
        Block curBlock = curBlockState.func_177230_c();
        if (curBlock == null || curBlock.equals(Blocks.field_150350_a) || BlockUtils.shouldNeverBeMessedWith(curBlock)) {
            if (curBlock != null && curBlockState.func_185904_a().func_76224_d()) {
                this.world.func_175698_g(blockToMine);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.func_184614_ca();
        if (getDrops) {
            int fortune = ItemStackUtils.getFortuneOf(tool);
            boolean silkTouch = ItemStackUtils.hasSilkTouch(tool);
            ArrayList<ItemStack> localItems = new ArrayList<ItemStack>();
            if (silkTouch && Item.func_150898_a((Block)BlockPosUtil.getBlock(this.world, blockToMine)) != null) {
                ItemStack silkItem = new ItemStack(Item.func_150898_a((Block)BlockPosUtil.getBlock(this.world, blockToMine)), 1);
                localItems.add(silkItem);
            } else {
                localItems.addAll(BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune));
            }
            for (ItemStack item : localItems) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            }
        }
        this.triggerMinedBlock(blockToMine);
        if (blockBreakAction == null) {
            this.worker.getCitizenItemHandler().breakBlockWithToolInHand(blockToMine);
        } else {
            blockBreakAction.run();
        }
        if (tool != null && damageTool) {
            tool.func_77973_b().func_77663_a(tool, this.world, (Entity)this.worker, this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tool.func_77973_b(), tool.func_77952_i()), true);
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        Block curBlock = this.world.func_180495_p(blockToMine).func_177230_c();
        if (!this.holdEfficientTool(curBlock, blockToMine)) {
            return true;
        }
        ItemStack tool = this.worker.func_184614_ca();
        if (tool != null && !ForgeHooks.canToolHarvestBlock((IBlockAccess)this.world, (BlockPos)blockToMine, (ItemStack)tool) && curBlock != Blocks.field_150357_h && curBlock.getHarvestTool(this.world.func_180495_p(blockToMine)) != null) {
            Log.getLogger().info(String.format("ForgeHook not in sync with EfficientTool for %s and %s\nPlease report to MineColonies with this text to add support!", curBlock, tool));
        }
        if (this.walkToBlock(safeStand) && MathUtils.twoDimDistance(this.worker.func_180425_c(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        this.currentStandingLocation = safeStand;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    private void triggerMinedBlock(@NotNull BlockPos blockToMine) {
        if (this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150365_q || this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150366_p || this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150369_x || this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150352_o || this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150450_ax || this.world.func_180495_p(blockToMine).func_177230_c() == Blocks.field_150412_bA) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("ores");
        }
        if (this.world.func_180495_p(blockToMine).func_177230_c().equals(Blocks.field_150482_ag)) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("diamonds");
        }
        if (this.world.func_180495_p(blockToMine).func_177230_c().equals(Blocks.field_150459_bM)) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("carrots");
        }
        if (this.world.func_180495_p(blockToMine).func_177230_c().equals(Blocks.field_150469_bN)) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("potatoes");
        }
        if (this.world.func_180495_p(blockToMine).func_177230_c().equals(Blocks.field_150464_aj)) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getStatsManager().incrementStatistic("wheat");
        }
    }

    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        if (this.worker.func_184614_ca() == null) {
            return (int)this.world.func_180495_p(pos).func_185887_b(this.world, pos);
        }
        return (int)((Configurations.gameplay.pvp_mode ? (double)(Configurations.gameplay.blockMiningDelayModifier / 2) : (double)Configurations.gameplay.blockMiningDelayModifier * Math.pow(0.85, this.worker.getCitizenExperienceHandler().getLevel())) * (double)this.world.func_180495_p(pos).func_185887_b(this.world, pos) / (double)this.worker.func_184614_ca().func_77973_b().func_150893_a(this.worker.func_184614_ca(), block.func_176223_P()));
    }

    public void fillItemsList() {
        this.searchForItems(this.worker.func_174813_aQ().func_72321_a(45.0, 3.0, 45.0).func_72321_a(-45.0, -3.0, -45.0));
    }

    public void searchForItems(AxisAlignedBB boundingBox) {
        this.items = this.world.func_72872_a(EntityItem.class, boundingBox).stream().filter(item -> item != null && !item.field_70128_L && (!item.getEntityData().func_74764_b("PreventRemoteMovement") || !item.getEntityData().func_74767_n("PreventRemoteMovement"))).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    public void gatherItems() {
        this.worker.func_98053_h(true);
        if (this.worker.getNavigator().func_75500_f()) {
            BlockPos pos = this.getAndRemoveClosestItemPosition();
            this.worker.isWorkerAtSiteWithMove(pos, 3);
            return;
        }
        if (this.worker.getNavigator().func_75505_d() == null) {
            this.setDelay(5);
            return;
        }
        int currentIndex = this.worker.getNavigator().func_75505_d().func_75873_e();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigator().func_75499_g();
            if (this.items != null && !this.items.isEmpty()) {
                this.items.remove(0);
            }
        }
    }

    private BlockPos getAndRemoveClosestItemPosition() {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).func_177951_i((Vec3i)this.worker.func_180425_c());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }

    public void resetGatheringItems() {
        this.items = null;
    }

    @Nullable
    public List<BlockPos> getItemsForPickUp() {
        return this.items == null ? null : new ArrayList<BlockPos>(this.items);
    }
}

