/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGearBuilder;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIFight<J extends AbstractJobGuard>
extends AbstractEntityAIInteract<J> {
    public final List<ToolType> toolsNeeded = new ArrayList<ToolType>();
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();
    private final Map<IToolType, List<GuardGear>> requiredArmor = new LinkedHashMap<IToolType, List<GuardGear>>();
    private final Map<IToolType, ItemStack> armorToWear = new HashMap<IToolType, ItemStack>();
    protected EntityLivingBase target = null;
    private static final double COMBAT_SPEED = 1.0;

    public AbstractEntityAIFight(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING, true), new AITarget(AIState.START_WORKING, true, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, true, this::prepare));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 0, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(1, 1, GuardConstants.GOLD_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 2, GuardConstants.CHAIN_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, 3, GuardConstants.IRON_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(4, 4, GuardConstants.DIA_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(4, 100, GuardConstants.DIA_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
    }

    @Override
    protected void updateRenderMetaData() {
        if (this.getState() != AIState.NEEDS_ITEM) {
            this.updateArmor();
        }
    }

    protected abstract int getAttackRange();

    private AIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.worker.goingToHut", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    private AIState prepare() {
        this.setDelay(100);
        AbstractBuildingGuards building = (AbstractBuildingGuards)this.getOwnBuilding();
        if (building == null || this.worker.getCitizenData() == null) {
            return AIState.PREPARING;
        }
        for (ToolType tool : this.toolsNeeded) {
            if (this.checkForToolOrWeapon(tool)) {
                return this.getState();
            }
            if (this.getOwnBuilding() == null) continue;
            InventoryFunctions.matchFirstInProviderWithSimpleAction((ICapabilityProvider)this.worker, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.doesItemServeAsWeapon(stack) && ItemStackUtils.hasToolLevel(stack, tool, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel()), itemStack -> this.worker.getCitizenItemHandler().setMainHeldItem((int)itemStack));
        }
        this.requiredArmor.clear();
        this.armorToWear.clear();
        LinkedHashMap correctArmor = new LinkedHashMap();
        for (List<GuardGear> list : this.itemsNeeded) {
            int level = this.worker.getCitizenData().getLevel();
            for (GuardGear item : list) {
                if (level < item.getMinLevelRequired() || level > item.getMaxLevelRequired() || building.getBuildingLevel() < item.getMinBuildingLevelRequired() || building.getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                ArrayList<GuardGear> listOfItems = new ArrayList<GuardGear>();
                listOfItems.add(item);
                if (correctArmor.containsKey(item.getItemNeeded())) {
                    listOfItems.addAll((Collection)correctArmor.get(item.getItemNeeded()));
                }
                correctArmor.put(item.getItemNeeded(), listOfItems);
            }
        }
        for (Map.Entry entry : correctArmor.entrySet()) {
            ItemStack armorStack;
            List<Integer> slotsWorker = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), itemStack -> ((List)entry.getValue()).stream().anyMatch(guardGear -> guardGear.test((ItemStack)itemStack)));
            int bestLevel = -1;
            ArrayList<Integer> nonOptimalSlots = new ArrayList<Integer>();
            int bestSlot = -1;
            for (int slot : slotsWorker) {
                int level;
                ItemStack stack2 = this.worker.getInventoryCitizen().func_70301_a(slot);
                if (ItemStackUtils.isEmpty(stack2).booleanValue() || (level = ItemStackUtils.getMiningLevel(stack2, (IToolType)entry.getKey())) <= bestLevel) continue;
                if (bestSlot != -1) {
                    nonOptimalSlots.add(bestLevel);
                }
                bestLevel = level;
                bestSlot = slot;
            }
            int bestLevelChest = -1;
            int bestSlotChest = -1;
            IItemHandler bestHandler = null;
            Map<IItemHandler, List<Integer>> slotsChest = InventoryUtils.findAllSlotsInProviderWith(building, itemStack -> ((List)entry.getValue()).stream().anyMatch(guardGear -> guardGear.test((ItemStack)itemStack)));
            for (Map.Entry<IItemHandler, List<Integer>> handlers : slotsChest.entrySet()) {
                for (int slot : handlers.getValue()) {
                    int level;
                    ItemStack stack3 = handlers.getKey().getStackInSlot(slot);
                    if (ItemStackUtils.isEmpty(stack3).booleanValue() || (level = ItemStackUtils.getMiningLevel(stack3, (IToolType)entry.getKey())) <= bestLevel || level <= bestLevelChest) continue;
                    bestLevelChest = level;
                    bestSlotChest = slot;
                    bestHandler = handlers.getKey();
                }
            }
            if (((List)entry.getValue()).isEmpty()) continue;
            if (bestLevelChest > bestLevel) {
                armorStack = bestHandler.getStackInSlot(bestSlotChest).func_77946_l();
                if (armorStack.func_77973_b() instanceof ItemArmor) {
                    this.armorToWear.put((IToolType)entry.getKey(), armorStack);
                }
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlotChest, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
                if (bestSlot != -1) {
                    nonOptimalSlots.add(bestSlot);
                }
            } else if (bestSlot == -1) {
                this.requiredArmor.put((IToolType)entry.getKey(), (List<GuardGear>)entry.getValue());
            } else {
                armorStack = new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getStackInSlot(bestSlot).func_77946_l();
                if (armorStack.func_77973_b() instanceof ItemArmor) {
                    this.armorToWear.put((IToolType)entry.getKey(), armorStack);
                }
            }
            Iterator<Map.Entry<Object, List<Integer>>> iterator = nonOptimalSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)((Object)iterator.next());
                InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), slot, building);
            }
        }
        return AIState.DECIDE;
    }

    public double getCombatMovementSpeed() {
        if (this.worker.getCitizenData() == null) {
            return 1.0;
        }
        double levelAdjustment = (double)this.worker.getCitizenData().getLevel() * 0.05;
        levelAdjustment = levelAdjustment > 1.0 ? 1.0 : levelAdjustment;
        return 1.0 + levelAdjustment;
    }

    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            int delay = 60 - this.worker.getCitizenData().getLevel();
            return delay > 10 ? 10 : delay;
        }
        return 60;
    }

    private void updateArmor() {
        if (this.worker.getRandom().nextInt(60) <= 0) {
            this.worker.func_184201_a(EntityEquipmentSlot.CHEST, ItemStackUtils.EMPTY);
            this.worker.func_184201_a(EntityEquipmentSlot.FEET, ItemStackUtils.EMPTY);
            this.worker.func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
            this.worker.func_184201_a(EntityEquipmentSlot.LEGS, ItemStackUtils.EMPTY);
            for (Map.Entry<IToolType, ItemStack> entry : this.armorToWear.entrySet()) {
                int slot;
                if (ItemStackUtils.isEmpty(entry.getValue()).booleanValue() || (slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), itemStack -> itemStack.func_185136_b((ItemStack)armorStack.getValue()))) == -1) continue;
                ItemStack stack = this.worker.getInventoryCitizen().func_70301_a(slot);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                    this.worker.func_184201_a(((ItemArmor)stack.func_77973_b()).field_77881_a, ItemStackUtils.EMPTY);
                    continue;
                }
                if (!(stack.func_77973_b() instanceof ItemArmor)) continue;
                this.worker.func_184201_a(((ItemArmor)stack.func_77973_b()).field_77881_a, stack);
                this.requiredArmor.remove(entry.getKey());
                this.cancelAsynchRequestForArmor(entry.getKey());
            }
            for (Map.Entry<IToolType, Object> entry : this.requiredArmor.entrySet()) {
                int minLevel = Integer.MAX_VALUE;
                int maxLevel = -1;
                for (GuardGear item : (List)entry.getValue()) {
                    if (item.getMinArmorLevel() < minLevel) {
                        minLevel = item.getMinArmorLevel();
                    }
                    if (item.getMaxArmorLevel() <= maxLevel) continue;
                    maxLevel = item.getMaxArmorLevel();
                }
                this.checkForToolorWeaponASync(entry.getKey(), minLevel, maxLevel);
            }
        }
    }
}

