/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIStatePausedHandler;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob>
extends AbstractAISkeleton<J> {
    protected static final int STANDARD_DELAY = 5;
    protected static final int REQUEST_DELAY = 60;
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    @Nullable
    protected BlockPos currentStandingLocation = null;
    private int delay = 0;
    private boolean hasDelayed = false;
    private IWalkToProxy proxy;
    private int exceptionTimer = 1;
    private int slotAt = 0;
    protected static final int WALK_DELAY = 20;
    protected Predicate<ItemStack> needsCurrently = null;
    protected BlockPos walkTo = null;
    private final List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(this::initSafetyChecks, true), new AITarget(this::updateVisualState, true), new AITarget(this::waitingForSomething, true, this::getState), new AITarget(() -> (this.getState() == AIState.NEEDS_ITEM || ((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData()) || ((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), r -> !this.worker.getCitizenData().isRequestAsync((IToken)r.getToken()))) && !this.isPaused(), true, this::waitForRequests), new AITarget(AIState.INVENTORY_FULL, true, this::dumpInventory), new AITarget(this::inventoryNeedsDump, AIState.INVENTORY_FULL, true), new AITarget(() -> this.getState() == AIState.NEEDS_TOOL && !this.isPaused() && ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Tool.class)).isEmpty(), AIState.IDLE, true), new AITarget(AIState.GATHERING_REQUIRED_MATERIALS, true, this::getNeededItem), new AITarget(this::shouldRestart, true, this::restart), new AITarget(AIState.PAUSED, true, () -> !this.isPaused(), () -> AIState.IDLE), new AITarget(AIState.PAUSED, true, this::bePaused), new AITarget(this::isPaused, AIState.INVENTORY_FULL, true));
    }

    private AIState getNeededItem() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
        this.setDelay(5);
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        if (this.needsCurrently == null || !InventoryUtils.hasItemInProvider(this.getOwnBuilding(), this.needsCurrently)) {
            return this.getStateAfterPickUp();
        }
        if (this.walkTo == null) {
            BlockPos pos = ((AbstractBuildingContainer)this.getOwnBuilding()).getTileEntity().getPositionOfChestWithItemStack(this.needsCurrently);
            if (pos == null) {
                return this.getStateAfterPickUp();
            }
            this.walkTo = pos;
        }
        if (this.walkToBlock(this.walkTo) && !this.worker.getCitizenStuckHandler().isStuck()) {
            this.setDelay(2);
            return this.getState();
        }
        boolean transferred = this.tryTransferFromPosToWorker(this.walkTo, this.needsCurrently);
        if (!transferred) {
            this.walkTo = null;
            return this.getStateAfterPickUp();
        }
        this.walkTo = null;
        return this.getStateAfterPickUp();
    }

    public AIState getStateAfterPickUp() {
        return AIState.START_WORKING;
    }

    @Nullable
    public <W extends AbstractBuildingWorker> W getOwnBuilding() {
        W worker = this.getOwnBuilding(this.getExpectedBuildingClass());
        return worker == null ? null : (W)worker;
    }

    public Class getExpectedBuildingClass() {
        return AbstractBuildingWorker.class;
    }

    @Nullable
    public <W extends AbstractBuildingWorker> W getOwnBuilding(@NotNull Class<W> type) {
        if (type.isInstance(this.worker.getCitizenColonyHandler().getWorkBuilding())) {
            return (W)this.worker.getCitizenColonyHandler().getWorkBuilding();
        }
        if (this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().setJob(null);
        }
        return null;
    }

    @Override
    protected void onException(RuntimeException e) {
        try {
            int timeout = 100 * this.exceptionTimer;
            this.setDelay(timeout);
            this.exceptionTimer *= 2;
            if (this.worker != null) {
                String name = this.worker.func_70005_c_();
                BlockPos workerPosition = this.worker.func_180425_c();
                AbstractJob colonyJob = this.worker.getCitizenJobHandler().getColonyJob();
                String jobName = colonyJob == null ? "null" : colonyJob.getName();
                Log.getLogger().error("Pausing Entity " + name + " (" + jobName + ") at " + workerPosition + " for " + timeout + " Seconds because of error:");
            } else {
                Log.getLogger().error("Pausing Entity that is null for " + timeout + " Seconds because of error:");
            }
            e.printStackTrace();
        }
        catch (RuntimeException exp) {
            Log.getLogger().error("Welp reporting crashed:");
            exp.printStackTrace();
            Log.getLogger().error("Caused by ai exception:");
            e.printStackTrace();
        }
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    private boolean inventoryNeedsDump() {
        return this.getState() != AIState.INVENTORY_FULL && (this.worker.getCitizenInventoryHandler().isInventoryFull() || this.job.getActionsDone() >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped()) && !(this.job instanceof JobDeliveryman);
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @Nullable
    private AIState initSafetyChecks() {
        if (null == this.getOwnBuilding()) {
            if (this.getState() == AIState.INIT) {
                return AIState.INIT;
            }
            return AIState.IDLE;
        }
        if (this.getState() == AIState.INIT) {
            return AIState.IDLE;
        }
        return null;
    }

    private AIState updateVisualState() {
        this.job.setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.currentStandingLocation != null && !this.worker.isWorkerAtSiteWithMove(this.currentStandingLocation, 4)) {
                return true;
            }
            if (this.delay % 5 == 0) {
                this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            --this.delay;
            return true;
        }
        this.clearWorkTarget();
        return false;
    }

    private void clearWorkTarget() {
        this.currentStandingLocation = null;
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    private AIState waitForRequests() {
        this.delay = 10;
        this.updateWorkerStatusFromRequests();
        return this.lookForRequests();
    }

    private void updateWorkerStatusFromRequests() {
        if (!((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequests(this.worker.getCitizenData()) && !((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[0]);
            return;
        }
        IRequest request = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequests(this.worker.getCitizenData()).stream().findFirst().orElse(null);
        if (request == null) {
            request = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequests(this.worker.getCitizenData()).stream().findFirst().orElse(null);
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.waiting", new Object[0]), request.getShortDisplayString()});
    }

    @NotNull
    private AIState lookForRequests() {
        if (!((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), r -> !this.worker.getCitizenData().isRequestAsync((IToken)r.getToken())) && !((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            return this.afterRequestPickUp();
        }
        if (!this.walkToBuilding() && ((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.delay += 10;
            ImmutableList<IRequest> completedRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequests(this.worker.getCitizenData());
            completedRequests.stream().filter(r -> !r.canBeDelivered()).forEach(r -> ((AbstractBuilding)this.getOwnBuilding()).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)r.getToken()));
            IRequest firstDeliverableRequest = completedRequests.stream().filter(IRequest::canBeDelivered).findFirst().orElse(null);
            if (firstDeliverableRequest != null) {
                boolean async = false;
                if (this.worker.getCitizenData().isRequestAsync((IToken)firstDeliverableRequest.getToken())) {
                    async = true;
                    this.job.getAsyncRequests().remove(firstDeliverableRequest.getToken());
                }
                ((AbstractBuilding)this.getOwnBuilding()).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)firstDeliverableRequest.getToken());
                ItemStack deliveredItemStack = firstDeliverableRequest.getDelivery();
                int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(deliveredItemStack, stack, true, true));
                if (count >= deliveredItemStack.func_190916_E()) {
                    return AIState.NEEDS_ITEM;
                }
                if (InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(deliveredItemStack, stack, true, true)) >= deliveredItemStack.func_190916_E() && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(deliveredItemStack, stack, true, true), deliveredItemStack.func_190916_E(), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) {
                    return AIState.NEEDS_ITEM;
                }
                if (async) {
                    this.worker.getCitizenData().createRequestAsync(firstDeliverableRequest.getRequest());
                } else {
                    this.worker.getCitizenData().createRequest(firstDeliverableRequest.getRequest());
                }
            }
        }
        return AIState.NEEDS_ITEM;
    }

    public AIState afterRequestPickUp() {
        return AIState.IDLE;
    }

    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        return deliveredItemStack.func_190916_E();
    }

    protected final boolean walkToBuilding() {
        Object ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(((AbstractSchematicProvider)ownBuilding).getLocation());
    }

    public boolean isInHut(@Nullable Predicate<ItemStack> is) {
        Object building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isInTileEntity(((AbstractBuildingContainer)building).getTileEntity(), is);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : ((AbstractBuildingContainer)building).getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isInTileEntity((TileEntityChest)entity, is))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInHut(@Nullable ItemStack is) {
        Object building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isInTileEntity((TileEntity)((AbstractBuildingContainer)building).getTileEntity(), is);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : ((AbstractBuildingContainer)building).getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isInTileEntity(entity, is))) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    public boolean isInTileEntity(TileEntity entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack, true, true) != false, this::takeItemStackFromProvider);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this.worker);
        }
        if (!this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, stand, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, @Nullable BlockPos stand, int timeout) {
        this.currentWorkingLocation = target;
        this.currentStandingLocation = stand;
        this.delay = timeout;
    }

    public boolean isInTileEntity(TileEntityChest entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, itemStackSelectionPredicate, this::takeItemStackFromProvider);
    }

    public boolean retrieveToolInTileEntity(TileEntity entity, IToolType toolType, int minLevel, int maxLevel) {
        if (ToolType.NONE.equals(toolType)) {
            return false;
        }
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minLevel, maxLevel), this::takeItemStackFromProvider);
    }

    public void takeItemStackFromProvider(@NotNull ICapabilityProvider provider, int slotIndex) {
        InventoryUtils.transferItemStackIntoNextBestSlotFromProvider(provider, slotIndex, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType) {
        return this.checkForToolOrWeapon(toolType, 0);
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType, int minimalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (this.checkForNeededTool(toolType, minimalLevel)) {
            if (openToolRequests.isEmpty() && completedToolRequests.isEmpty()) {
                Tool request = new Tool(toolType, minimalLevel, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel() < minimalLevel ? minimalLevel : ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
                this.worker.getCitizenData().createRequest(request);
            }
            return true;
        }
        return false;
    }

    protected void checkForToolorWeaponASync(@NotNull IToolType toolType, int minimalLevel, int maximalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (openToolRequests.isEmpty() && completedToolRequests.isEmpty() && !this.hasOpenToolRequest(toolType)) {
            Tool request = new Tool(toolType, minimalLevel, maximalLevel);
            this.worker.getCitizenData().createRequestAsync(request);
        }
    }

    protected void cancelAsynchRequestForArmor(IToolType armorType) {
        ImmutableList openRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), iRequest -> ((Tool)iRequest.getRequest()).getToolClass() == armorType);
        for (IRequest token : openRequests) {
            this.worker.getCitizenColonyHandler().getColony().getRequestManager().updateRequestState((IToken<?>)token.getToken(), RequestState.COMPLETED);
        }
    }

    private boolean hasOpenToolRequest(IToolType key) {
        return ((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), iRequest -> iRequest.getRequest() instanceof Tool && ((Tool)iRequest.getRequest()).getToolClass() == key);
    }

    private boolean checkForNeededTool(@NotNull IToolType toolType, int minimalLevel) {
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        if (InventoryUtils.isToolInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), toolType, minimalLevel, maxToolLevel)) {
            return false;
        }
        this.delay += 10;
        return this.walkToBuilding() || !this.retrieveToolInHut(toolType, minimalLevel);
    }

    public boolean retrieveToolInHut(IToolType toolType, int minimalLevel) {
        Object building = this.getOwnBuilding();
        if (building != null) {
            if (this.retrieveToolInTileEntity((TileEntity)((AbstractBuildingContainer)building).getTileEntity(), toolType, minimalLevel, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel())) {
                return true;
            }
            for (BlockPos pos : ((AbstractBuildingContainer)building).getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !this.retrieveToolInTileEntity((TileEntity)((TileEntityChest)entity), toolType, minimalLevel, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private AIState dumpInventory() {
        if (!this.worker.isWorkerAtSiteWithMove(((AbstractSchematicProvider)this.getOwnBuilding()).getLocation(), 4)) {
            return AIState.INVENTORY_FULL;
        }
        if (InventoryUtils.isProviderFull(this.getOwnBuilding())) {
            if (!((AbstractBuildingContainer)this.getOwnBuilding()).getPriorityState()) {
                ((AbstractBuildingContainer)this.getOwnBuilding()).alterPickUpPriority(10);
            }
            this.chatSpamFilter.talkWithoutSpam("entity.worker.inventoryFullChestFull", new Object[0]);
        } else if (this.dumpOneMoreSlot()) {
            this.delay += 10;
            return AIState.INVENTORY_FULL;
        }
        this.alreadyKept.clear();
        this.slotAt = 0;
        this.itemsNiceToHave().forEach(this::isInHut);
        this.clearActionsDone();
        return this.afterDump();
    }

    public AIState afterDump() {
        if (this.isPaused()) {
            ((AbstractBuilding)this.getOwnBuilding()).onCleanUp(this.worker.getCitizenData());
            return AIState.PAUSED;
        }
        return AIState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        long openSlots;
        if (this.walkToBuilding()) {
            return true;
        }
        Object buildingWorker = this.getOwnBuilding();
        ItemStack stackToDump = this.worker.getInventoryCitizen().func_70301_a(this.slotAt);
        int totalSize = this.worker.getInventoryCitizen().func_70302_i_();
        boolean dumpAnyway = false;
        if ((long)this.slotAt + 10L >= (long)totalSize && (openSlots = InventoryUtils.openSlotCount((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) < 10L) {
            dumpAnyway = this.worker.getRandom().nextBoolean();
        }
        if (buildingWorker != null && !ItemStackUtils.isEmpty(stackToDump).booleanValue()) {
            int amount;
            int n = amount = dumpAnyway ? stackToDump.func_190916_E() : ((AbstractBuilding)buildingWorker).buildingRequiresCertainAmountOfItem(stackToDump, this.alreadyKept, true);
            if (amount > 0) {
                ItemStack activeStack = new InvWrapper((IInventory)this.getInventory()).extractItem(this.slotAt, amount, false);
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)((AbstractBuildingContainer)buildingWorker).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            }
        }
        ++this.slotAt;
        return this.slotAt < totalSize;
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        this.job.clearActionsDone();
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    public final boolean holdEfficientTool(@NotNull Block target, BlockPos pos) {
        int bestSlot = this.getMostEfficientTool(target);
        if (bestSlot >= 0) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, bestSlot);
            return true;
        }
        this.requestTool(target, pos);
        return false;
    }

    private void requestTool(@NotNull Block target, BlockPos pos) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target);
        int required = WorkerUtil.getCorrectHavestLevelForBlock(target);
        if (((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel() < required) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.request.toolow", new ItemStack(target).func_82833_r(), pos.toString());
        }
        this.updateToolFlag(toolType, required);
    }

    private void updateToolFlag(@NotNull IToolType toolType, int required) {
        if (ToolType.PICKAXE.equals(toolType)) {
            this.checkForToolOrWeapon(toolType, required);
        } else {
            this.checkForToolOrWeapon(toolType);
        }
    }

    protected int getMostEfficientTool(@NotNull Block target) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target);
        int required = WorkerUtil.getCorrectHavestLevelForBlock(target);
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = ItemStackUtils.getMiningLevel(item, toolType);
            if (level < required || level >= bestLevel || toolType != ToolType.NONE && !ItemStackUtils.verifyToolLevel(item, level, required, maxToolLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    protected final void incrementActionsDoneAndDecSaturation() {
        this.worker.decreaseSaturationForAction();
        this.incrementActionsDone();
    }

    protected final void incrementActionsDone() {
        this.job.incrementActionsDone();
    }

    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return targetPosition;
    }

    public BlockPos getWorkingPosition(int distance, BlockPos targetPos, int offset) {
        EnumFacing[] directions;
        if (offset > 25) {
            return targetPos;
        }
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
            BlockPos positionInDirection = this.getPositionInDirection(direction, distance + offset, targetPos);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection) || this.world.func_180495_p(positionInDirection.func_177984_a()).func_177230_c() == Blocks.field_150345_g) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(distance, targetPos, offset + 1);
    }

    @NotNull
    private BlockPos getPositionInDirection(EnumFacing facing, int distance, BlockPos targetPos) {
        return BlockPosUtil.getFloor(targetPos.func_177967_a(facing, distance), this.world);
    }

    public boolean checkIfRequestForItemExistOrCreate(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreate(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreate);
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack))) {
            return true;
        }
        if (((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack);
            this.worker.getCitizenData().createRequest(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreateAsynch(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreateAsynch);
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull ItemStack stack) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack) != false && s.func_190916_E() >= stack.func_190916_E())) {
            return true;
        }
        if (InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, true)) >= stack.func_190916_E() && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, true), stack.func_190916_E(), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) {
            return true;
        }
        if (((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack);
            this.worker.getCitizenData().createRequestAsync(stackRequest);
        }
        return false;
    }

    private boolean tryTransferFromPosToWorker(BlockPos pos, @NotNull Predicate<ItemStack> predicate) {
        TileEntity entity = this.world.func_175625_s(pos);
        if (entity == null) {
            return false;
        }
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((ICapabilityProvider)entity, predicate, 64, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
    }

    private boolean isPaused() {
        return this.worker.getCitizenData().isPaused();
    }

    private AIState bePaused() {
        EntityAIStatePausedHandler.doPause(this.worker, this.getOwnBuilding());
        this.setDelay(20);
        return AIState.PAUSED;
    }

    private boolean shouldRestart() {
        return this.worker.getCitizenData().shouldRestart() && this.isPaused();
    }

    private AIState restart() {
        ((AbstractBuilding)this.getOwnBuilding()).onCleanUp(this.worker.getCitizenData());
        ((AbstractBuilding)this.getOwnBuilding()).onRestart(this.worker.getCitizenData());
        this.setDelay(20);
        this.worker.getCitizenData().restartDone();
        return AIState.INIT;
    }
}

