/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class MakeNotAutoDeletableCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "deletable";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String MARKED = "Marking successful!";
    private static final String NOT_ENOUGH_ARGUMENTS = "You must have 2 Arguments: <ColonyId> <true|false> ";
    private static final int NUMBER_OR_ARGS_REQUIRED = 2;

    public MakeNotAutoDeletableCommand() {
        super(new String[0]);
    }

    public MakeNotAutoDeletableCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <true|false>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return false;
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        boolean canBeDeleted = actionMenuState.getBooleanValueForArgument("canBeDeleted", false);
        this.executeShared(server, sender, colony, canBeDeleted);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NOT_ENOUGH_ARGUMENTS));
            return;
        }
        int colonyId = Integer.parseInt(args[0]);
        Colony colony = ColonyManager.getColonyByWorld(colonyId, (World)server.func_71218_a(0));
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            return;
        }
        boolean canBeDeleted = Boolean.parseBoolean(args[1]);
        this.executeShared(server, sender, colony, canBeDeleted);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @Nullable Colony colony, boolean canBeDeleted) {
        if (sender instanceof EntityPlayer && !MakeNotAutoDeletableCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        if (sender instanceof TileEntity) {
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(MARKED));
        colony.setCanBeAutoDeleted(canBeDeleted);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && MakeNotAutoDeletableCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

