/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.commands.ActionArgument;
import com.minecolonies.coremod.commands.ActionArgumentType;
import com.minecolonies.coremod.commands.ActionMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import org.jetbrains.annotations.NotNull;

public class ActionMenuState {
    @NotNull
    private final ActionMenu actionMenu;
    @NotNull
    private final Map<String, ArgumentState> argumentStateByActionArgumentNameMap = new HashMap<String, ArgumentState>();

    public ActionMenuState(@NotNull ActionMenu actionMenu) {
        this.actionMenu = actionMenu;
    }

    public ActionMenu getActionMenu() {
        return this.actionMenu;
    }

    public boolean isValueSet(@NotNull ActionArgument actionArgument) {
        ArgumentState argumentState = this.argumentStateByActionArgumentNameMap.get(actionArgument.getName());
        if (null == argumentState) {
            return false;
        }
        return argumentState.valueIsSet;
    }

    public Object getValue(@NotNull ActionArgument actionArgument) {
        ArgumentState argumentState = this.argumentStateByActionArgumentNameMap.get(actionArgument.getName());
        if (null == argumentState) {
            return null;
        }
        return argumentState.value;
    }

    public void setValue(@NotNull ActionArgument actionArgument, @NotNull Object newValue) {
        ArgumentState argumentState = this.argumentStateByActionArgumentNameMap.get(actionArgument.getName());
        if (null == argumentState) {
            argumentState = new ArgumentState();
            this.argumentStateByActionArgumentNameMap.put(actionArgument.getName(), argumentState);
        }
        argumentState.value = newValue;
        argumentState.valueIsSet = true;
    }

    private List<ActionArgument> getAllArgumentsList() {
        return this.getAllArgumentsList(this.actionMenu.getActionArgumentList());
    }

    private List<ActionArgument> getAllArgumentsList(@NotNull List<ActionArgument> currentActionArgumentList) {
        ArrayList<ActionArgument> allActionArgumentsList = new ArrayList<ActionArgument>();
        for (ActionArgument actionArgument : currentActionArgumentList) {
            allActionArgumentsList.add(actionArgument);
            if (!this.isValueSet(actionArgument)) continue;
            allActionArgumentsList.addAll(this.getAllArgumentsList(actionArgument.getActionArgumentList()));
        }
        return allActionArgumentsList;
    }

    public Colony getColonyForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || ActionArgumentType.COLONY != actionArgument.getType()) continue;
            return (Colony)this.getValue(actionArgument);
        }
        return null;
    }

    public EntityPlayerMP getPlayerForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || ActionArgumentType.ONLINE_PLAYER != actionArgument.getType() && ActionArgumentType.PLAYER != actionArgument.getType()) continue;
            return (EntityPlayerMP)this.getValue(actionArgument);
        }
        return null;
    }

    public EntityPlayerMP getOnlinePlayerForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || ActionArgumentType.ONLINE_PLAYER != actionArgument.getType()) continue;
            return (EntityPlayerMP)this.getValue(actionArgument);
        }
        return null;
    }

    public CitizenData getCitizenForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || ActionArgumentType.CITIZEN != actionArgument.getType()) continue;
            return (CitizenData)this.getValue(actionArgument);
        }
        return null;
    }

    @Nullable
    public Boolean getBooleanForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || ActionArgumentType.BOOLEAN != actionArgument.getType()) continue;
            return (Boolean)this.getValue(actionArgument);
        }
        return null;
    }

    public boolean getBooleanValueForArgument(@NotNull String argumentName, boolean defaultValue) {
        Boolean booleanObject = this.getBooleanForArgument(argumentName);
        if (null != booleanObject) {
            return booleanObject;
        }
        return defaultValue;
    }

    public Integer getIntegerForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName())) continue;
            switch (actionArgument.getType()) {
                case INTEGER: 
                case COORDINATE_X: 
                case COORDINATE_Y: 
                case COORDINATE_Z: {
                    return (Integer)this.getValue(actionArgument);
                }
            }
        }
        return null;
    }

    public Double getDoubleForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName())) continue;
            switch (actionArgument.getType()) {
                case DOUBLE: {
                    return (Double)this.getValue(actionArgument);
                }
            }
        }
        return null;
    }

    public String getStringForArgument(@NotNull String argumentName) {
        for (ActionArgument actionArgument : this.getAllArgumentsList()) {
            if (!argumentName.equals(actionArgument.getName()) || actionArgument.getType() != ActionArgumentType.STRING) continue;
            return (String)this.getValue(actionArgument);
        }
        return null;
    }

    public int getIntValueForArgument(@NotNull String argumentName, int defaultValue) {
        Integer integerObject = this.getIntegerForArgument(argumentName);
        if (null != integerObject) {
            return integerObject;
        }
        return defaultValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionMenu == null ? 0 : this.actionMenu.hashCode());
        result = 31 * result + this.argumentStateByActionArgumentNameMap.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionMenuState other = (ActionMenuState)obj;
        if (this.actionMenu == null ? other.actionMenu != null : !this.actionMenu.equals(other.actionMenu)) {
            return false;
        }
        return this.argumentStateByActionArgumentNameMap.equals(other.argumentStateByActionArgumentNameMap);
    }

    public String toString() {
        return "ActionMenuState [actionMenu=" + this.actionMenu + ", argumentStateByActionArgumentNameMap=" + this.argumentStateByActionArgumentNameMap + "]";
    }

    private static class ArgumentState {
        private boolean valueIsSet = false;
        @Nullable
        private Object value = null;

        private ArgumentState() {
        }
    }
}

