/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.google.common.primitives.Ints;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.coremod.commands.AbstractCommandParser;
import com.minecolonies.coremod.commands.ActionArgument;
import com.minecolonies.coremod.commands.ActionMenu;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.CommandEntryPointNew;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public enum ActionArgumentType {
    ONLINE_PLAYER("online-player-expression", 0),
    PLAYER("player-expression", 0),
    COLONY("colony-id", 0),
    CITIZEN("citizen-id or full-name", 9),
    COORDINATE_X("x-coordinate", 0),
    COORDINATE_Y("y-coordinate", 0),
    COORDINATE_Z("z-coordinate", 0),
    BOOLEAN("boolean", 0),
    INTEGER("integer", 0),
    STRING("string", 0),
    DOUBLE("double", 0);

    private static final String ABANDONED_FAKE_PLAYER_NAME = "[abandoned]";
    @Nonnull
    private final String usageValue;
    private final int allowedSpaceCount;

    private ActionArgumentType(String usageValue, int allowedSpaceCount) {
        this.usageValue = usageValue;
        this.allowedSpaceCount = allowedSpaceCount;
    }

    public String getUsageValue() {
        return this.usageValue;
    }

    public int allowedSpaceCount() {
        return this.allowedSpaceCount;
    }

    @NotNull
    private static List<String> getOnlinePlayerNames(@NotNull MinecraftServer server) {
        String[] onlinePlayerNames = server.func_71213_z();
        return Arrays.asList(onlinePlayerNames);
    }

    @NotNull
    private static List<String> getAllPlayerNames(@NotNull MinecraftServer server) {
        PlayerList playerList = server.func_184103_al();
        List allPlayersList = playerList.func_181057_v();
        ArrayList<String> playerNames = new ArrayList<String>(allPlayersList.size());
        for (EntityPlayerMP entityPlayerMP : allPlayersList) {
            String playerName = entityPlayerMP.func_70005_c_();
            if (playerNames.contains(playerName)) continue;
            playerNames.add(playerName);
        }
        return playerNames;
    }

    @NotNull
    private static List<String> getColonyIdStrings(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider) {
        List<Colony> colonyList = mineColonyDataProvider.getColonies();
        ArrayList<String> colonyIdList = new ArrayList<String>(colonyList.size());
        for (Colony colony : colonyList) {
            colonyIdList.add(String.valueOf(colony.getID()));
        }
        return colonyIdList;
    }

    private static List<String> getCitizenNames(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, @Nullable Colony colonyToUse) {
        List<Colony> colonyList = null != colonyToUse ? Collections.singletonList(colonyToUse) : mineColonyDataProvider.getColonies();
        ArrayList<String> citizenNameList = new ArrayList<String>();
        for (Colony colony : colonyList) {
            List<CitizenData> citizenDataList = colony.getCitizenManager().getCitizens();
            for (CitizenData citizenData : citizenDataList) {
                citizenNameList.add(citizenData.getName());
            }
        }
        return citizenNameList;
    }

    @NotNull
    private static List<String> getCitizenIds(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, @Nullable Colony colonyToUse) {
        List<Colony> colonyList = null != colonyToUse ? Collections.singletonList(colonyToUse) : mineColonyDataProvider.getColonies();
        ArrayList<String> citizenNameList = new ArrayList<String>();
        for (Colony colony : colonyList) {
            List<CitizenData> citizenDataList = colony.getCitizenManager().getCitizens();
            for (CitizenData citizenData : citizenDataList) {
                citizenNameList.add(String.valueOf(citizenData.getId()));
            }
        }
        return citizenNameList;
    }

    @NotNull
    public List<String> getTabCompletions(@NotNull MinecraftServer server, @Nullable BlockPos pos, @NotNull AbstractCommandParser.ModuleContext moduleContext, @NotNull ActionMenuState actionMenuState, String potentialArgumentValue) {
        CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider = moduleContext.get(CommandEntryPointNew.MineColonyDataProvider.class);
        switch (this) {
            case INTEGER: 
            case STRING: {
                return Collections.emptyList();
            }
            case BOOLEAN: {
                return ActionArgumentType.getBooleanTabCompletions(potentialArgumentValue);
            }
            case COORDINATE_X: 
            case COORDINATE_Y: 
            case COORDINATE_Z: {
                return this.getCoordinateTabCompletions(pos, potentialArgumentValue);
            }
            case ONLINE_PLAYER: {
                List<String> onlinePlayerNameStrings = ActionArgumentType.getOnlinePlayerNames(server);
                return onlinePlayerNameStrings.stream().filter(k -> k.startsWith(potentialArgumentValue)).collect(Collectors.toList());
            }
            case PLAYER: {
                List<String> allPlayerNameStrings = ActionArgumentType.getAllPlayerNames(server);
                return allPlayerNameStrings.stream().filter(k -> k.startsWith(potentialArgumentValue)).collect(Collectors.toList());
            }
            case COLONY: {
                return this.getColonyTabCompletions(mineColonyDataProvider, potentialArgumentValue);
            }
            case CITIZEN: {
                return this.getCitizenTabCompletions(mineColonyDataProvider, actionMenuState, potentialArgumentValue);
            }
        }
        throw new IllegalStateException("Unimplemented ActionArgumentType tab completion");
    }

    @NotNull
    private List<String> getCoordinateTabCompletions(@Nullable BlockPos pos, String potentialArgumentValue) {
        if (null == pos) {
            return Collections.emptyList();
        }
        if (potentialArgumentValue.isEmpty()) {
            switch (this) {
                case COORDINATE_X: {
                    return Collections.singletonList(String.valueOf(pos.func_177958_n()));
                }
                case COORDINATE_Y: {
                    return Collections.singletonList(String.valueOf(pos.func_177956_o()));
                }
                case COORDINATE_Z: {
                    return Collections.singletonList(String.valueOf(pos.func_177952_p()));
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<String> getColonyTabCompletions(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, String potentialArgumentValue) {
        List<String> colonyNumberStrings = ActionArgumentType.getColonyIdStrings(mineColonyDataProvider);
        if (potentialArgumentValue.isEmpty()) {
            return colonyNumberStrings;
        }
        Integer result = Ints.tryParse((String)potentialArgumentValue);
        if (null != result) {
            return colonyNumberStrings.stream().filter(k -> k.startsWith(potentialArgumentValue)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<String> getCitizenTabCompletions(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, @NotNull ActionMenuState actionMenuState, String potentialArgumentValue) {
        Integer result;
        Colony colony = null;
        ActionMenu actionMenu = actionMenuState.getActionMenu();
        for (ActionArgument actionArgument : actionMenu.getActionArgumentList()) {
            if (COLONY == actionArgument.getType() && null != (colony = (Colony)actionMenuState.getValue(actionArgument))) break;
        }
        List<String> citizenNameStrings = ActionArgumentType.getCitizenNames(mineColonyDataProvider, colony);
        List<String> citizenNumberStrings = ActionArgumentType.getCitizenIds(mineColonyDataProvider, colony);
        String[] potentiaCitizenNameParts = potentialArgumentValue.split(" ", -1);
        int currentWordIndex = potentiaCitizenNameParts.length - 1;
        if (potentialArgumentValue.isEmpty()) {
            HashSet<String> nameSet = new HashSet<String>();
            for (String citizenName : citizenNameStrings) {
                String[] citizenNameParts = citizenName.split(" ");
                nameSet.add(citizenNameParts[currentWordIndex]);
            }
            ArrayList<String> result2 = new ArrayList<String>(nameSet);
            if (0 == currentWordIndex) {
                result2.addAll(citizenNumberStrings);
            }
            return result2;
        }
        if (0 == currentWordIndex && null != (result = Ints.tryParse((String)potentialArgumentValue))) {
            return citizenNumberStrings.stream().filter(k -> k.startsWith(potentialArgumentValue)).collect(Collectors.toList());
        }
        HashSet<String> nameAtIndexStringSet = new HashSet<String>();
        for (String citizenName : citizenNameStrings) {
            int i;
            String[] citizenNameParts = citizenName.split(" ");
            if (citizenNameParts.length <= currentWordIndex) continue;
            for (i = 0; i < currentWordIndex && potentiaCitizenNameParts[i].equals(citizenNameParts[i]); ++i) {
            }
            if (i != currentWordIndex) continue;
            nameAtIndexStringSet.add(citizenNameParts[currentWordIndex]);
        }
        if (!nameAtIndexStringSet.isEmpty()) {
            return nameAtIndexStringSet.stream().filter(k -> k.startsWith(potentiaCitizenNameParts[currentWordIndex])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public Object parse(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @Nullable BlockPos pos, @NotNull AbstractCommandParser.ModuleContext moduleContext, @NotNull ActionMenuState actionMenuState, String potentialArgumentValue) {
        CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider = moduleContext.get(CommandEntryPointNew.MineColonyDataProvider.class);
        switch (this) {
            case INTEGER: 
            case COORDINATE_X: 
            case COORDINATE_Y: 
            case COORDINATE_Z: {
                return Ints.tryParse((String)potentialArgumentValue);
            }
            case BOOLEAN: {
                return ActionArgumentType.parseBoolean(potentialArgumentValue);
            }
            case ONLINE_PLAYER: {
                return this.parseOnlinePlayerValue(server, potentialArgumentValue);
            }
            case PLAYER: {
                return this.parseAnyPlayerValue(server, potentialArgumentValue);
            }
            case COLONY: {
                return this.parseColonyValue(sender, mineColonyDataProvider, potentialArgumentValue);
            }
            case CITIZEN: {
                return this.parseCitizenDataValue(mineColonyDataProvider, actionMenuState, potentialArgumentValue);
            }
            case STRING: {
                return potentialArgumentValue.isEmpty() ? null : potentialArgumentValue;
            }
            case DOUBLE: {
                return potentialArgumentValue.isEmpty() ? 0.0 : Double.parseDouble(potentialArgumentValue);
            }
        }
        throw new IllegalStateException("Unimplemented ActionArgumentType parsing");
    }

    @Nullable
    private static Boolean parseBoolean(String potentialArgumentValue) {
        if ("true".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.TRUE;
        }
        if ("t".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.TRUE;
        }
        if ("yes".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.TRUE;
        }
        if ("y".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.TRUE;
        }
        if ("1".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.FALSE;
        }
        if ("f".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.FALSE;
        }
        if ("no".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.FALSE;
        }
        if ("n".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.FALSE;
        }
        if ("0".equalsIgnoreCase(potentialArgumentValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static List<String> getBooleanTabCompletions(String potentialArgumentValue) {
        if (potentialArgumentValue.isEmpty()) {
            return Arrays.asList("true", "false");
        }
        if ("true".startsWith(potentialArgumentValue) || "yes".startsWith(potentialArgumentValue) || "1".startsWith(potentialArgumentValue)) {
            return Collections.singletonList("true");
        }
        if ("false".startsWith(potentialArgumentValue) || "no".startsWith(potentialArgumentValue) || "0".startsWith(potentialArgumentValue)) {
            return Collections.singletonList("false");
        }
        return Collections.emptyList();
    }

    @Nullable
    private EntityPlayerMP parseOnlinePlayerValue(@NotNull MinecraftServer server, String potentialArgumentValue) {
        List<String> playerNameStrings = ActionArgumentType.getOnlinePlayerNames(server);
        if (playerNameStrings.contains(potentialArgumentValue)) {
            return server.func_184103_al().func_152612_a(potentialArgumentValue);
        }
        if (ABANDONED_FAKE_PLAYER_NAME.equals(potentialArgumentValue)) {
            return new FakePlayer(server.func_71218_a(0), new GameProfile(UUID.randomUUID(), ABANDONED_FAKE_PLAYER_NAME));
        }
        return null;
    }

    @Nullable
    private EntityPlayerMP parseAnyPlayerValue(@NotNull MinecraftServer server, String potentialArgumentValue) {
        List<String> playerNameStrings = ActionArgumentType.getAllPlayerNames(server);
        if (playerNameStrings.contains(potentialArgumentValue)) {
            return server.func_184103_al().func_152612_a(potentialArgumentValue);
        }
        if (ABANDONED_FAKE_PLAYER_NAME.equals(potentialArgumentValue)) {
            return new FakePlayer(server.func_71218_a(0), new GameProfile(UUID.randomUUID(), ABANDONED_FAKE_PLAYER_NAME));
        }
        return null;
    }

    @Nullable
    private Colony parseColonyValue(@NotNull ICommandSender sender, @NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, String potentialArgumentValue) {
        List<String> colonyNumberStrings = ActionArgumentType.getColonyIdStrings(mineColonyDataProvider);
        Integer result = Ints.tryParse((String)potentialArgumentValue);
        if (null != result) {
            IColony icolony;
            int colonyNumber = result;
            if (sender instanceof EntityPlayer && colonyNumber == -1 && (icolony = mineColonyDataProvider.getIColonyByOwner(sender.func_130014_f_(), (EntityPlayer)sender)) != null) {
                colonyNumber = icolony.getID();
            }
            if (colonyNumberStrings.contains(String.valueOf(colonyNumber))) {
                return mineColonyDataProvider.getColony(colonyNumber);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private CitizenData parseCitizenDataValue(@NotNull CommandEntryPointNew.MineColonyDataProvider mineColonyDataProvider, @NotNull ActionMenuState actionMenuState, String potentialArgumentValue) {
        Colony colony = null;
        List<ActionArgument> actionArgumentList = actionMenuState.getActionMenu().getActionArgumentList();
        for (ActionArgument actionArgument : actionArgumentList) {
            if (actionArgument.getType() != COLONY || !actionMenuState.isValueSet(actionArgument)) continue;
            colony = actionMenuState.getColonyForArgument(actionArgument.getName());
            break;
        }
        if (null != colony) {
            ICitizenManager citizenManager = colony.getCitizenManager();
            return this.findCitizenForCitizenManager(citizenManager, potentialArgumentValue);
        }
        List<Colony> colonyList = mineColonyDataProvider.getColonies();
        for (Colony someColony : colonyList) {
            ICitizenManager citizenManager = someColony.getCitizenManager();
            CitizenData citizen = this.findCitizenForCitizenManager(citizenManager, potentialArgumentValue);
            if (null == citizen) continue;
            return citizen;
        }
        return null;
    }

    @Nullable
    private CitizenData findCitizenForCitizenManager(@NotNull ICitizenManager citizenManager, String potentialArgumentValue) {
        List<CitizenData> citizenDataList = citizenManager.getCitizens();
        for (CitizenData citizenData : citizenDataList) {
            if (!citizenData.getName().equalsIgnoreCase(potentialArgumentValue)) continue;
            return citizenData;
        }
        Integer result = Ints.tryParse((String)potentialArgumentValue);
        if (null != result) {
            int citizenId = result;
            return citizenManager.getCitizen(citizenId);
        }
        return null;
    }

    public static enum Is {
        REQUIRED,
        OPTIONAL;

    }
}

