/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.ISubCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSingleCommand
implements ISubCommand {
    public static final String NOT_PERMITTED = "You are not allowed to do that!";
    private final String[] parents;

    public AbstractSingleCommand(String ... parents) {
        this.parents = (String[])parents.clone();
    }

    public static int getIthArgument(String[] args, int i, int def) {
        if (args.length <= i) {
            return def;
        }
        try {
            return Integer.parseInt(args[i]);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        StringBuilder sb = new StringBuilder().append('/');
        for (String parent : this.parents) {
            sb.append(parent).append(' ');
        }
        return sb.toString();
    }

    public boolean canPlayerUseCommand(EntityPlayer player, Commands theCommand, int colonyId) {
        if (AbstractSingleCommand.isPlayerOpped((ICommandSender)player)) {
            return true;
        }
        Colony chkColony = ColonyManager.getColonyByWorld(colonyId, (World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0));
        if (chkColony == null) {
            return false;
        }
        return AbstractSingleCommand.canCommandSenderUseCommand(theCommand) && this.canRankUseCommand(chkColony, player);
    }

    @NotNull
    public static boolean isPlayerOpped(@NotNull ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(((EntityPlayer)sender).func_146103_bH());
        }
        return true;
    }

    public static boolean canCommandSenderUseCommand(Commands theCommand) {
        switch (theCommand) {
            case HOMETP: {
                return Configurations.gameplay.canPlayerUseHomeTPCommand;
            }
            case COLONYTP: {
                return Configurations.gameplay.canPlayerUseColonyTPCommand;
            }
            case RTP: {
                return Configurations.gameplay.canPlayerUseRTPCommand;
            }
            case KILLCITIZENS: {
                return Configurations.gameplay.canPlayerUseKillCitizensCommand;
            }
            case CITIZENINFO: {
                return Configurations.gameplay.canPlayerUseCitizenInfoCommand;
            }
            case LISTCITIZENS: {
                return Configurations.gameplay.canPlayerUseListCitizensCommand;
            }
            case RESPAWNCITIZENS: {
                return Configurations.gameplay.canPlayerRespawnCitizensCommand;
            }
            case SHOWCOLONYINFO: {
                return Configurations.gameplay.canPlayerUseShowColonyInfoCommand;
            }
            case ADDOFFICER: {
                return Configurations.gameplay.canPlayerUseAddOfficerCommand;
            }
            case DELETECOLONY: {
                return Configurations.gameplay.canPlayerUseDeleteColonyCommand;
            }
            case REFRESH_COLONY: {
                return Configurations.gameplay.canPlayerUseRefreshColonyCommand;
            }
            case MC_BACKUP: {
                return Configurations.gameplay.canPlayerUseBackupCommand;
            }
            case RSRESET: {
                return Configurations.requestSystem.canPlayerUseResetCommand;
            }
        }
        return false;
    }

    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Rank.OFFICER) || colony.getPermissions().getRank(player).equals((Object)Rank.OWNER);
    }

    public static enum Commands {
        CITIZENINFO,
        COLONYTP,
        RTP,
        DELETECOLONY,
        SPAWNCITZENS,
        KILLCITIZENS,
        LISTCITIZENS,
        RESPAWNCITIZENS,
        SHOWCOLONYINFO,
        ADDOFFICER,
        CHANGE_COLONY_OWNER,
        REFRESH_COLONY,
        HOMETP,
        MC_BACKUP,
        RSRESET;

    }
}

