/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkManager {
    private static final String TAG_WORK_ORDERS = "workOrders";
    protected final Colony colony;
    @NotNull
    private final Map<Integer, AbstractWorkOrder> workOrders = new LinkedHashMap<Integer, AbstractWorkOrder>();
    private int topWorkOrderId = 0;
    private boolean dirty = false;

    public WorkManager(Colony c) {
        this.colony = c;
    }

    public void removeWorkOrder(@NotNull AbstractWorkOrder order) {
        this.removeWorkOrder(order.getID());
    }

    public void removeWorkOrder(int orderId) {
        AbstractWorkOrder workOrder = this.workOrders.get(orderId);
        this.workOrders.remove(orderId);
        this.colony.removeWorkOrderInView(orderId);
        workOrder.onRemoved(this.colony);
        this.colony.markDirty();
    }

    @Nullable
    public <W extends AbstractWorkOrder> W getWorkOrder(int id, @NotNull Class<W> type) {
        AbstractWorkOrder workOrder = this.getWorkOrder(id);
        if (type.isInstance(workOrder)) {
            return (W)((AbstractWorkOrder)type.cast(workOrder));
        }
        return null;
    }

    public AbstractWorkOrder getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Nullable
    public <W extends AbstractWorkOrder> W getUnassignedWorkOrder(@NotNull Class<W> type) {
        for (AbstractWorkOrder o : this.workOrders.values()) {
            if (o.isClaimed() || !type.isInstance(o)) continue;
            return (W)((AbstractWorkOrder)type.cast(o));
        }
        return null;
    }

    public <W extends AbstractWorkOrder> List<W> getWorkOrdersOfType(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @NotNull
    public Map<Integer, AbstractWorkOrder> getWorkOrders() {
        return this.workOrders;
    }

    public void clearWorkForCitizen(@NotNull CitizenData citizen) {
        this.dirty = true;
        this.workOrders.values().stream().filter(o -> o != null && o.isClaimedBy(citizen)).forEach(AbstractWorkOrder::clearClaimedBy);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (AbstractWorkOrder o : this.workOrders.values()) {
            NBTTagCompound orderCompound = new NBTTagCompound();
            o.writeToNBT(orderCompound);
            list.func_74742_a((NBTBase)orderCompound);
        }
        compound.func_74782_a(TAG_WORK_ORDERS, (NBTBase)list);
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c(TAG_WORK_ORDERS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound orderCompound = list.func_150305_b(i);
            AbstractWorkOrder o = AbstractWorkOrder.createFromNBT(orderCompound);
            if (o == null) continue;
            this.addWorkOrder(o, true);
            if (o.isClaimed() && this.colony.getCitizenManager().getCitizen(o.getClaimedBy()) == null) {
                o.clearClaimedBy();
            }
            this.topWorkOrderId = Math.max(this.topWorkOrderId, o.getID());
        }
    }

    public void addWorkOrder(@NotNull AbstractWorkOrder order, boolean readingFromNbt) {
        this.dirty = true;
        if (order.getID() == 0) {
            ++this.topWorkOrderId;
            order.setID(this.topWorkOrderId);
        }
        this.workOrders.put(order.getID(), order);
        order.onAdded(this.colony, readingFromNbt);
    }

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Colony.shallUpdate(event.world, 20)) {
            Iterator<AbstractWorkOrder> iter = this.workOrders.values().iterator();
            while (iter.hasNext()) {
                AbstractWorkOrder o = iter.next();
                if (!o.isValid(this.colony)) {
                    iter.remove();
                    this.dirty = true;
                    continue;
                }
                if (!o.hasChanged()) continue;
                this.dirty = true;
                o.resetChange();
            }
        }
    }

    public <W extends AbstractWorkOrder> List<W> getOrderedList(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(o -> !o.isClaimed() && type.isInstance(o)).map(o -> o).sorted(Comparator.comparingInt(AbstractWorkOrder::getPriority).reversed()).collect(Collectors.toList());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

