/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingDependentRequestResolver<R extends IRequestable>
extends AbstractRequestResolver<R>
implements IBuildingBasedRequester {
    public AbstractBuildingDependentRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends R> requestToCheck) {
        ILocation requesterLocation;
        if (!manager.getColony().getWorld().field_72995_K && (requesterLocation = requestToCheck.getRequester().getRequesterLocation()).equals(this.getRequesterLocation())) {
            Optional<AbstractBuilding> building = this.getBuilding(manager, (IToken<?>)requestToCheck.getToken()).map(r -> (AbstractBuilding)r);
            return building.map(b -> this.canResolveForBuilding(manager, (IRequest<? extends R>)requestToCheck, (AbstractBuilding)b)).orElse(false);
        }
        return false;
    }

    @Override
    @Nullable
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        BuildingBasedRequester requester;
        ILocation requesterLocation;
        IRequest<?> request = manager.getRequestForToken(token);
        if (request.getRequester() instanceof BuildingBasedRequester && (requesterLocation = (requester = (BuildingBasedRequester)request.getRequester()).getRequesterLocation()).equals(this.getRequesterLocation())) {
            return requester.getBuilding(manager, token);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token, int counter) {
        BuildingBasedRequester requester;
        ILocation requesterLocation;
        IRequest<?> request = manager.getRequestForToken(token);
        if (request.getRequester() instanceof BuildingBasedRequester && (requesterLocation = (requester = (BuildingBasedRequester)request.getRequester()).getRequesterLocation()).equals(this.getRequesterLocation())) {
            return requester.getBuilding(manager, token);
        }
        return Optional.empty();
    }

    public abstract boolean canResolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public abstract List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    public abstract void resolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);
}

