/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PrivateWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    @Nullable
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        IRequest<?> parent;
        IRequest<?> request = manager.getRequestForToken(token);
        if (request == null) {
            return Optional.empty();
        }
        if (request.hasParent() && (parent = manager.getRequestForToken((IToken<?>)request.getParent())).getRequester() instanceof IBuildingBasedRequester) {
            return ((IBuildingBasedRequester)parent.getRequester()).getBuilding(manager, (IToken<?>)parent.getToken(), 0);
        }
        if (request.getRequester() instanceof IBuildingBasedRequester) {
            return ((IBuildingBasedRequester)request.getRequester()).getBuilding(manager, token, 0);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token, int counter) {
        IRequest<?> parent;
        IRequest<?> request = manager.getRequestForToken(token);
        if (request == null || counter > 20) {
            return Optional.empty();
        }
        if (request.hasParent() && (parent = manager.getRequestForToken((IToken<?>)request.getParent())).getRequester() instanceof IBuildingBasedRequester) {
            return ((IBuildingBasedRequester)parent.getRequester()).getBuilding(manager, (IToken<?>)parent.getToken(), counter + 1);
        }
        if (request.getRequester() instanceof IBuildingBasedRequester) {
            return ((IBuildingBasedRequester)request.getRequester()).getBuilding(manager, token, counter + 1);
        }
        return Optional.empty();
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker building, ItemStack stack) {
        return building.getFirstRecipe(stack) != null;
    }

    @Override
    @Nullable
    public IRequest<?> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> request) {
        return null;
    }

    @Override
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> request) {
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        IRequest<?> request = manager.getRequestForToken(token);
        if (request == null) {
            return new TextComponentString("<UNKNOWN>");
        }
        if (!request.hasParent()) {
            return new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        request = manager.getRequestForToken((IToken<?>)request.getParent());
        if (request == null) {
            return new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        return request.getRequester().getDisplayName(manager, (IToken<?>)request.getToken()).func_150257_a((ITextComponent)new TextComponentString(" (")).func_150257_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(")"));
    }

    @Override
    public int getPriority() {
        return 125;
    }
}

