/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.IRequestFactory;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.colony.requestsystem.requests.StandardRequests;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public final class StandardRequestFactories {
    private static final String NBT_REQUESTER = "Requester";
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_STATE = "State";
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_PARENT = "Parent";
    private static final String NBT_CHILDREN = "Children";

    private StandardRequestFactories() {
    }

    public static <T extends IRequestable> NBTTagCompound serializeToNBT(IFactoryController controller, IRequest<T> request, IObjectToNBTConverter<T> typeSerialization) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound requesterCompound = controller.serialize(request.getRequester());
        NBTTagCompound tokenCompound = controller.serialize(request.getToken());
        NBTTagInt stateCompound = request.getState().serializeNBT();
        NBTTagCompound requestedCompound = typeSerialization.apply(controller, request.getRequest());
        NBTTagList childrenCompound = new NBTTagList();
        for (IToken token : request.getChildren()) {
            childrenCompound.func_74742_a((NBTBase)controller.serialize(token));
        }
        compound.func_74782_a(NBT_REQUESTER, (NBTBase)requesterCompound);
        compound.func_74782_a(NBT_TOKEN, (NBTBase)tokenCompound);
        compound.func_74782_a(NBT_STATE, (NBTBase)stateCompound);
        compound.func_74782_a(NBT_REQUESTED, (NBTBase)requestedCompound);
        if (request.hasResult()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)typeSerialization.apply(controller, request.getResult()));
        }
        if (request.hasParent()) {
            compound.func_74782_a(NBT_PARENT, (NBTBase)controller.serialize(request.getParent()));
        }
        compound.func_74782_a(NBT_CHILDREN, (NBTBase)childrenCompound);
        return compound;
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromNBT(IFactoryController controller, NBTTagCompound compound, INBTToObjectConverter<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(compound.func_74775_l(NBT_REQUESTER));
        IToken token = (IToken)controller.deserialize(compound.func_74775_l(NBT_TOKEN));
        RequestState state = RequestState.deserializeNBT((NBTTagInt)compound.func_74781_a(NBT_STATE));
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, compound.func_74775_l(NBT_REQUESTED));
        ArrayList childTokens = new ArrayList();
        NBTTagList childCompound = compound.func_150295_c(NBT_CHILDREN, 10);
        for (int i = 0; i < childCompound.func_74745_c(); ++i) {
            childTokens.add(controller.deserialize(childCompound.func_150305_b(i)));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (compound.func_74764_b(NBT_PARENT)) {
            request.setParent((IToken)controller.deserialize(compound.func_74775_l(NBT_PARENT)));
        }
        if (compound.func_74764_b(NBT_RESULT)) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, compound.func_74775_l(NBT_RESULT)));
        }
        return (R)request;
    }

    @FunctionalInterface
    public static interface IObjectConstructor<T, O> {
        public O construct(@NotNull T var1, @NotNull IToken var2, @NotNull IRequester var3, @NotNull RequestState var4);
    }

    @FunctionalInterface
    public static interface INBTToObjectConverter<O> {
        public O apply(IFactoryController var1, NBTTagCompound var2);
    }

    @FunctionalInterface
    public static interface IObjectToNBTConverter<O> {
        public NBTTagCompound apply(IFactoryController var1, O var2);
    }

    public static final class BurnableRequestFactory
    implements IRequestFactory<Burnable, StandardRequests.BurnableRequest> {
        @Override
        public StandardRequests.BurnableRequest getNewInstance(@NotNull Burnable input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.BurnableRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.BurnableRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.BurnableRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Burnable> getFactoryInputType() {
            return TypeToken.of(Burnable.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.BurnableRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Burnable::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.BurnableRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class SmeltableOreRequestFactory
    implements IRequestFactory<SmeltableOre, StandardRequests.SmeltAbleOreRequest> {
        @Override
        public StandardRequests.SmeltAbleOreRequest getNewInstance(@NotNull SmeltableOre input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.SmeltAbleOreRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.SmeltAbleOreRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.SmeltAbleOreRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends SmeltableOre> getFactoryInputType() {
            return TypeToken.of(SmeltableOre.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.SmeltAbleOreRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, SmeltableOre::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.SmeltAbleOreRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class FoodRequestFactory
    implements IRequestFactory<Food, StandardRequests.FoodRequest> {
        @Override
        public StandardRequests.FoodRequest getNewInstance(@NotNull Food input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.FoodRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.FoodRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.FoodRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Food> getFactoryInputType() {
            return TypeToken.of(Food.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.FoodRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Food::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.FoodRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class ToolRequestFactory
    implements IRequestFactory<Tool, StandardRequests.ToolRequest> {
        @Override
        public StandardRequests.ToolRequest getNewInstance(@NotNull Tool input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.ToolRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.ToolRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ToolRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Tool> getFactoryInputType() {
            return TypeToken.of(Tool.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ToolRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Tool::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ToolRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class DeliveryRequestFactory
    implements IRequestFactory<Delivery, StandardRequests.DeliveryRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.DeliveryRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.DeliveryRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Delivery> getFactoryInputType() {
            return TypeToken.of(Delivery.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.DeliveryRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Delivery::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.DeliveryRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.DeliveryRequest getNewInstance(@NotNull Delivery input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.DeliveryRequest(location, token, initialState, input);
        }
    }

    public static final class ItemStackListRequestFactory
    implements IRequestFactory<StackList, StandardRequests.ItemStackListRequest> {
        @Override
        public StandardRequests.ItemStackListRequest getNewInstance(@NotNull StackList input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackListRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackListRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackListRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<StackList> getFactoryInputType() {
            return TypeToken.of(StackList.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackListRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, StackList::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackListRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class ItemStackRequestFactory
    implements IRequestFactory<Stack, StandardRequests.ItemStackRequest> {
        @Override
        public StandardRequests.ItemStackRequest getNewInstance(@NotNull Stack input, @NotNull IRequester location, @NotNull IToken token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Stack> getFactoryInputType() {
            return TypeToken.of(Stack.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }
    }
}

