/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.update.IUpdateStep;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.update.implementation.CraftingUpdate;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.update.implementation.InitialUpdate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpdateHandler {
    private static final List<IUpdateStep> steps = new ArrayList<IUpdateStep>();

    public static void handleUpdate(@NotNull IStandardRequestManager manager) {
        if (manager.getColony().isRemote()) {
            return;
        }
        steps.stream().filter(s -> s.updatesToVersion() > manager.getCurrentVersion()).sorted(Comparator.comparing(IUpdateStep::updatesToVersion)).forEachOrdered(s -> {
            s.update(manager);
            manager.setCurrentVersion(s.updatesToVersion());
        });
    }

    public static int getCurrentVersion() {
        return steps.stream().max(Comparator.comparing(IUpdateStep::updatesToVersion)).get().updatesToVersion();
    }

    static {
        steps.add(new InitialUpdate());
        steps.add(new CraftingUpdate());
    }
}

